<?php use Illuminate\Support\Facades\Request; ?>
<div class="vertical-menu">
    <div data-simplebar class="h-100">
        <div id="sidebar-menu">
            <ul class="metismenu list-unstyled" id="side-menu">

                <!-- === MAIN === -->
                <li class="menu-title" data-key="t-menu"><?php echo e(__('dashboard.menus')); ?></li>

                <!-- Website -->
                <li>
                    <a href="<?php echo e(route('website.home')); ?>" target="_blank">
                        <i class="fas fa-globe"></i>
                        <span><?php echo e(__('dashboard.website')); ?></span>
                    </a>
                </li>

                <li>
                    <a href="<?php echo e(route('dashboard.home')); ?>">
                        <i class="fas fa-globe"></i>
                        <span><?php echo e(__('dashboard.dashboard')); ?></span>
                    </a>
                </li>
                
                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('statistics.view')): ?>
                    <li>
                        <a href="<?php echo e(route('dashboard.statistics.index')); ?>">
                            <i class="fas fa-chart-bar"></i>
                            <span><?php echo e(__('dashboard.statistics')); ?></span>
                        </a>
                    </li>
                <?php endif; ?>

                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('contact_messages.view')): ?>
                    <li>
                        <a href="<?php echo e(route('dashboard.contact_messages.index')); ?>">
                            <i class="fas fa-envelope"></i>
                            <span><?php echo e(__('dashboard.contact_messages')); ?></span>
                        </a>
                    </li>
                <?php endif; ?>


                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('subscribers.view')): ?>
                    <li>
                        <a href="<?php echo e(route('dashboard.subscribers.index')); ?>">
                            <i class="fas fa-users"></i>
                            <span><?php echo e(__('dashboard.subscribers')); ?></span>
                        </a>
                    </li>
                <?php endif; ?>

                <!-- === CONTENT MANAGEMENT === -->
                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('menus.view')): ?>
                    <li>
                        <a href="<?php echo e(route('dashboard.menus.index')); ?>">
                            <i class="fas fa-list-alt"></i>
                            <span><?php echo e(__('dashboard.menus')); ?></span>
                        </a>
                    </li>
                <?php endif; ?>

                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('sliders.view')): ?>
                    <li>
                        <a href="<?php echo e(route('dashboard.sliders.index')); ?>">
                            <i class="fas fa-images"></i>
                            <span><?php echo e(__('dashboard.sliders')); ?></span>
                        </a>
                    </li>
                <?php endif; ?>

                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('sections.view')): ?>
                    <li>
                        <a href="<?php echo e(route('dashboard.sections.index')); ?>">
                            <i class="fas fa-th-large"></i>
                            <span><?php echo e(__('dashboard.sections')); ?></span>
                        </a>
                    </li>
                <?php endif; ?>
                <!-- === SERVICES & PRODUCTS === -->
                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('categories.view')): ?>
                    <li>
                        <a href="<?php echo e(route('dashboard.categories.index')); ?>">
                            <i class="bx bx-git-branch "></i>
                            <span><?php echo e(__('dashboard.categories')); ?></span>
                        </a>
                    </li>
                <?php endif; ?>
                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('services.view')): ?>
                    <li>
                        <a href="<?php echo e(route('dashboard.services.index')); ?>">
                            <i class="fas fa-concierge-bell"></i>
                            <span><?php echo e(__('dashboard.services')); ?></span>
                        </a>
                    </li>
                <?php endif; ?>

                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('products.view')): ?>
                    <li>
                        <a href="<?php echo e(route('dashboard.products.index')); ?>">
                            <i class="fas fa-box"></i>
                            <span><?php echo e(__('dashboard.products')); ?></span>
                        </a>
                    </li>
                <?php endif; ?>

                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('projects.view')): ?>
                    <li>
                        <a href="<?php echo e(route('dashboard.projects.index')); ?>">
                            <i class="fas fa-box"></i>
                            <span><?php echo e(__('dashboard.projects')); ?></span>
                        </a>
                    </li>
                <?php endif; ?>

                <!-- === ALBUMS === -->
                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('albums.view')): ?>
                    <li>
                        <a href="<?php echo e(route('dashboard.albums.index')); ?>">
                            <i class="fas fa-box"></i>
                            <span><?php echo e(__('dashboard.albums')); ?></span>
                        </a>
                    </li>
                <?php endif; ?>
                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('faqs.view')): ?>
                    <li>
                        <a href="<?php echo e(route('dashboard.faqs.index')); ?>">
                            <i class="fas fa-question-circle"></i>
                            <span><?php echo e(__('dashboard.faqs')); ?></span>
                        </a>
                    </li>
                <?php endif; ?>

                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('testimonials.view')): ?>
                    <li>
                        <a href="<?php echo e(route('dashboard.testimonials.index')); ?>">
                            <i class="fas fa-comment-dots"></i>
                            <span><?php echo e(__('dashboard.testimonials')); ?></span>
                        </a>
                    </li>
                <?php endif; ?>

                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('gallery_videos.view')): ?>
                    <li>
                        <a href="<?php echo e(route('dashboard.gallery_videos.index')); ?>">
                            <i class="fas fa-video"></i>
                            <span><?php echo e(__('dashboard.gallery_videos')); ?></span>
                        </a>
                    </li>
                <?php endif; ?>

                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('pages.view')): ?>
                    <li>
                        <a href="<?php echo e(route('dashboard.pages.index')); ?>">
                            <i class="fas fa-file-alt"></i>
                            <span data-key="t-dashboard"><?php echo e(__('dashboard.pages')); ?></span>
                        </a>
                    </li>
                <?php endif; ?>

                <!-- === ABOUT === -->
                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('about.edit')): ?>
                    <li>
                        <a href="javascript:void(0);" class="has-arrow">
                            <i class="fas fa-info-circle"></i>
                            <span><?php echo e(__('dashboard.about_us')); ?></span>
                        </a>
                        <ul class="sub-menu" aria-expanded="false">
                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('about.edit')): ?>
                                <li><a href="<?php echo e(route('dashboard.about.edit')); ?>"><?php echo e(__('dashboard.about_us')); ?></a></li>
                            <?php endif; ?>
                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('about_structs.view')): ?>
                                <li><a
                                        href="<?php echo e(route('dashboard.about-structs.index')); ?>"><?php echo e(__('dashboard.about_structs')); ?></a>
                                </li>
                            <?php endif; ?>
                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('benefits.view')): ?>
                                <li><a href="<?php echo e(route('dashboard.benefits.index')); ?>"><?php echo e(__('dashboard.benefits')); ?></a></li>
                            <?php endif; ?>
                        </ul>
                    </li>
                <?php endif; ?>


                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('plans.view')): ?>
                    <li>
                        <a href="javascript:void(0);" class="has-arrow">
                            <i class="fas fa-boxes"></i>
                            <span><?php echo e(__('dashboard.plans')); ?></span>
                        </a>
                        <ul class="sub-menu" aria-expanded="false">
                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('attributes.view')): ?>
                                <li><a href="<?php echo e(route('dashboard.attributes.index')); ?>"><?php echo e(__('dashboard.attributes')); ?></a>
                                </li>
                            <?php endif; ?>
                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('plans.view')): ?>
                                <li><a href="<?php echo e(route('dashboard.plans.index')); ?>"><?php echo e(__('dashboard.plans')); ?></a></li>
                            <?php endif; ?>
                        </ul>
                    </li>
                <?php endif; ?>

                <!-- === HOSTING & DOMAINS === -->
                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('hostings.view')): ?>
                    <li>
                        <a href="<?php echo e(route('dashboard.hostings.index')); ?>">
                            <i class="fas fa-server"></i>
                            <span><?php echo e(__('dashboard.hostings')); ?></span>
                        </a>
                    </li>
                <?php endif; ?>

                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('domains.view')): ?>
                    <li>
                        <a href="<?php echo e(route('dashboard.domains.index')); ?>">
                            <i class="fas fa-globe-americas"></i>
                            <span><?php echo e(__('dashboard.domains')); ?></span>
                        </a>
                    </li>
                <?php endif; ?>

                <!-- === BLOG === -->
                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('blogs.view')): ?>
                    <li>
                        <a href="javascript:void(0);" class="has-arrow">
                            <i class="fas fa-blog"></i>
                            <span><?php echo e(__('dashboard.blogs')); ?></span>
                        </a>
                        <ul class="sub-menu" aria-expanded="false">
                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('blog_categories.view')): ?>
                                <li><a
                                        href="<?php echo e(route('dashboard.blog_categories.index')); ?>"><?php echo e(__('dashboard.blog_categories')); ?></a>
                                </li>
                            <?php endif; ?>
                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('authors.view')): ?>
                                <li><a href="<?php echo e(route('dashboard.authors.index')); ?>"><?php echo e(__('dashboard.authors')); ?></a></li>
                            <?php endif; ?>
                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('blogs.view')): ?>
                                <li><a href="<?php echo e(route('dashboard.blogs.index')); ?>"><?php echo e(__('dashboard.blogs')); ?></a></li>
                            <?php endif; ?>
                        </ul>
                    </li>
                <?php endif; ?>

                <!-- === JOBS & CAREERS === -->
                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('job_positions.view')): ?>
                    <li>
                        <a href="javascript:void(0);" class="has-arrow">
                            <i class="fas fa-user-tie"></i>
                            <span><?php echo e(__('dashboard.job_positions')); ?></span>
                        </a>
                        <ul class="sub-menu" aria-expanded="false">
                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('job_positions.view')): ?>
                                <li><a
                                        href="<?php echo e(route('dashboard.job_positions.index')); ?>"><?php echo e(__('dashboard.job_positions')); ?></a>
                                </li>
                            <?php endif; ?>
                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('career_applications.view')): ?>
                                <li><a
                                        href="<?php echo e(route('dashboard.career_applications.index')); ?>"><?php echo e(__('dashboard.career_applications')); ?></a>
                                </li>
                            <?php endif; ?>
                        </ul>
                    </li>
                <?php endif; ?>

                <!-- === CLIENTS & PARTENERS === -->
                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('clients.view')): ?>
                    <li>
                        <a href="<?php echo e(route('dashboard.clients.index')); ?>">
                            <i class="fas fa-user-friends"></i>
                            <span><?php echo e(__('dashboard.clients')); ?></span>
                        </a>
                    </li>
                <?php endif; ?>

                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('parteners.view')): ?>
                    <li>
                        <a href="<?php echo e(route('dashboard.parteners.index')); ?>">
                            <i class="fas fa-user-friends"></i>
                            <span><?php echo e(__('dashboard.parteners')); ?></span>
                        </a>
                    </li>
                <?php endif; ?>

                <!-- === SITE ADDRESSES === -->
                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('site_addresses.view')): ?>
                    <li>
                        <a href="<?php echo e(route('dashboard.site-addresses.index')); ?>">
                            <i class="fas fa-map-marker-alt"></i>
                            <span><?php echo e(__('dashboard.site_addresses')); ?></span>
                        </a>
                    </li>
                <?php endif; ?>

                
                <li>
                    <a href="<?php echo e(route('dashboard.phones.index')); ?>">
                        <i class="fas fa-phone"></i>
                        <span><?php echo e(__('dashboard.phones')); ?></span>
                    </a>
                </li>
                
                <li>
                    <a href="javascript:void(0);" class="has-arrow">
                        <i class="fas fa-cogs"></i>
                        <span><?php echo e(__('dashboard.seo')); ?></span>
                    </a>
                    <ul class="sub-menu" aria-expanded="false">
                        <li>
                            <a href="<?php echo e(route('dashboard.dashboard.generate-sitemap')); ?>" target="_blank">
                                <i class="fas fa-globe"></i>
                                <span> Generate Sitemap</span>
                            </a>
                        </li>
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('seo_assistants.view')): ?>
                            <li><a
                                    href="<?php echo e(route('dashboard.seo-assistants.index')); ?>"><?php echo e(__('dashboard.seo_assistant')); ?></a>
                            </li>
                        <?php endif; ?>
                        <li><a href="<?php echo e(route('dashboard.ai-content.index')); ?>"><i class="fas fa-robot"></i>
                                <?php echo e(__('dashboard.ai_content_generation')); ?></a></li>
                        <li><a href="<?php echo e(route('dashboard.seo.testing')); ?>"><i class="fas fa-search-plus"></i>
                                <?php echo e(__('dashboard.seo_testing')); ?></a></li>
                        <li>
                            <a href="<?php echo e(route('dashboard.search-console.index')); ?>">
                                <i class="fas fa-search"></i>
                                <span>Search Console</span>
                            </a>
                        </li>


                        <li>
                            <a href="<?php echo e(route('dashboard.analytics.index')); ?>">
                                <i class="fas fa-chart-line"></i>
                                <span>Google Analytics</span>
                            </a>
                        </li>

                        <li>
                            <a href="<?php echo e(route('dashboard.redirects.index')); ?>">
                                <i class="fas fa-random"></i>
                                <span>Redirects</span>
                            </a>
                        </li>
                        <li>
                            <a href="<?php echo e(route('dashboard.performance.index')); ?>">
                                <i class="fas fa-tachometer-alt"></i>
                                <span><?php echo e(__('dashboard.performance_monitoring')); ?></span>
                            </a>
                        </li>
                        <li>
                            <a href="<?php echo e(route('dashboard.redirects.import-form')); ?>">
                                <i class="fas fa-file-import"></i>
                                <span>Import Redirects</span>
                            </a>
                        </li>

                    </ul>
                </li>
                <!-- === SETTINGS === -->
                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('settings.edit')): ?>
                    <li>
                        <a href="javascript:void(0);" class="has-arrow">
                            <i class="fas fa-cogs"></i>
                            <span><?php echo e(__('dashboard.management_settings')); ?></span>
                        </a>
                        <ul class="sub-menu" aria-expanded="false">
                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('settings.edit')): ?>
                                <li><a href="<?php echo e(route('dashboard.settings.show')); ?>"><?php echo e(__('dashboard.settings')); ?></a></li>
                            <?php endif; ?>
                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('configrations_ar.view')): ?>
                                <li><a
                                        href="<?php echo e(route('dashboard.configrations.edit', 'ar')); ?>"><?php echo e(__('dashboard.configration_ar')); ?></a>
                                </li>
                            <?php endif; ?>
                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('configrations_en.view')): ?>
                                <li><a
                                        href="<?php echo e(route('dashboard.configrations.edit', 'en')); ?>"><?php echo e(__('dashboard.configration_en')); ?></a>
                                </li>
                            <?php endif; ?>
                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('configrations_fr.view')): ?>
                                <li><a
                                        href="<?php echo e(route('dashboard.configrations.edit', 'fr')); ?>"><?php echo e(__('dashboard.configration_fr')); ?></a>
                                </li>
                            <?php endif; ?>

                        </ul>
                    </li>
                <?php endif; ?>
                <!-- === ADMINISTRATION === -->
                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('admins.view')): ?>
                    <li>
                        <a href="javascript:void(0);" class="has-arrow">
                            <i class="fas fa-users-cog"></i>
                            <span><?php echo e(__('dashboard.management_users')); ?></span>
                        </a>
                        <ul class="sub-menu" aria-expanded="false">
                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('admins.view')): ?>
                                <li><a href="<?php echo e(route('dashboard.admins.index')); ?>"><?php echo e(__('dashboard.admins')); ?></a></li>
                            <?php endif; ?>
                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('roles.view')): ?>
                                <li><a href="<?php echo e(route('dashboard.roles.index')); ?>"><?php echo e(__('dashboard.roles')); ?></a></li>
                            <?php endif; ?>
                        </ul>
                    </li>
                <?php endif; ?>
            </ul>
        </div>
    </div>
</div>
<?php /**PATH /home/webtest3/public_html/tulip-new/resources/views/components/dashboard/partials/left-sidebar.blade.php ENDPATH**/ ?>