<x-dashboard.layout title="Redirects">
    <div class="d-flex justify-content-between align-items-center mb-3">
        <h4>Redirects</h4>
        <div class="d-flex gap-2">
            <a href="{{ route('dashboard.redirects.import-form') }}" class="btn btn-secondary">Import</a>
            <a href="{{ route('dashboard.redirects.create') }}" class="btn btn-primary">Add Redirect</a>
        </div>
    </div>

    @if($redirects->total() > 0)
    <div class="mb-3">
        <button type="button" class="btn btn-sm btn-danger" id="deleteSelectedBtn" disabled>
            <i class="fas fa-trash"></i> Delete Selected (<span id="selectedCount">0</span>)
        </button>
        <button type="button" class="btn btn-sm btn-outline-danger" id="deleteAllBtn">
            <i class="fas fa-trash-alt"></i> Delete All ({{ $redirects->total() }})
        </button>
    </div>
    @endif

    <div class="enhanced-page-header">
        <div class="card-body p-0">
            <div class="table-responsive">
                <table class="table table-striped mb-0">
                    <thead>
                        <tr>
                            <th width="50">
                                <input type="checkbox" id="selectAll" class="form-check-input">
                            </th>
                            <th>#</th>
                            <th>Source</th>
                            <th>Target</th>
                            <th>Status</th>
                            <th>Active</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        @forelse($redirects as $r)
                        <tr>
                            <td>
                                <input type="checkbox" class="form-check-input redirect-checkbox" value="{{ $r->id }}">
                            </td>
                            <td>{{ $r->id }}</td>
                            <td><code>{{ \Illuminate\Support\Str::limit($r->source, 50) }}</code></td>
                            <td><code>{{ $r->target ? \Illuminate\Support\Str::limit($r->target, 50) : '-' }}</code>
                            </td>
                            <td>
                                @if($r->status_code == 301)
                                <span class="badge bg-success">301</span>
                                @elseif($r->status_code == 302)
                                <span class="badge bg-info">302</span>
                                @else
                                <span class="badge bg-danger">410</span>
                                @endif
                            </td>
                            <td>
                                @if($r->is_active)
                                <span class="badge bg-success">Yes</span>
                                @else
                                <span class="badge bg-secondary">No</span>
                                @endif
                            </td>
                            <td class="d-flex gap-2">
                                <a href="{{ route('dashboard.redirects.edit', $r) }}"
                                    class="btn btn-sm btn-warning">Edit</a>
                                <form action="{{ route('dashboard.redirects.destroy', $r) }}" method="POST"
                                    onsubmit="return confirm('Delete redirect?')" class="d-inline">
                                    @csrf
                                    @method('DELETE')
                                    <button class="btn btn-sm btn-danger" type="submit">Delete</button>
                                </form>
                            </td>
                        </tr>
                        @empty
                        <tr>
                            <td colspan="7" class="text-center text-muted">No redirects</td>
                        </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>
        </div>
        <div class="card-footer">{{ $redirects->links() }}</div>
    </div>

    <form id="bulkDeleteForm" action="{{ route('dashboard.redirects.bulk-delete') }}" method="POST"
        style="display: none;">
        @csrf
        @method('DELETE')
        <input type="hidden" name="ids" id="bulkDeleteIds">
    </form>

    @push('scripts')
    <script>
    $(document).ready(function() {
        // Select all checkbox
        $('#selectAll').on('change', function() {
            $('.redirect-checkbox').prop('checked', this.checked);
            updateSelectedCount();
        });

        // Individual checkbox
        $('.redirect-checkbox').on('change', function() {
            updateSelectedCount();
            updateSelectAllState();
        });

        // Update selected count
        function updateSelectedCount() {
            const count = $('.redirect-checkbox:checked').length;
            $('#selectedCount').text(count);
            $('#deleteSelectedBtn').prop('disabled', count === 0);
        }

        // Update select all state
        function updateSelectAllState() {
            const total = $('.redirect-checkbox').length;
            const checked = $('.redirect-checkbox:checked').length;
            $('#selectAll').prop('checked', total > 0 && checked === total);
        }

        // Delete selected
        $('#deleteSelectedBtn').on('click', function() {
            const selected = $('.redirect-checkbox:checked').map(function() {
                return this.value;
            }).get();

            if (selected.length === 0) {
                alert('Please select redirects to delete');
                return;
            }

            if (confirm(`Are you sure you want to delete ${selected.length} redirect(s)?`)) {
                $('#bulkDeleteIds').val(selected.join(','));
                $('#bulkDeleteForm').submit();
            }
        });

        // Delete all
        $('#deleteAllBtn').on('click', function() {
            if (confirm(
                    'Are you sure you want to delete ALL redirects? This action cannot be undone!')) {
                if (confirm(
                        'This will delete {{ $redirects->total() }} redirects. Are you absolutely sure?'
                    )) {
                    $.ajax({
                        url: '{{ route("dashboard.redirects.delete-all") }}',
                        type: 'POST',
                        data: {
                            _token: '{{ csrf_token() }}',
                            _method: 'DELETE'
                        },
                        success: function(response) {
                            alert(response.message);
                            window.location.reload();
                        },
                        error: function(xhr) {
                            alert('Error deleting redirects: ' + (xhr.responseJSON
                                ?.message || 'Unknown error'));
                        }
                    });
                }
            }
        });
    });
    </script>
    @endpush
</x-dashboard.layout>