<?php

namespace App\View\Composers;

use Illuminate\View\View;
use App\Models\Dashboard\Menu;
use Illuminate\Support\Facades\Cache;

class MenuComposer
{
    public function compose(View $view): void
    {
        try {
            $hierarchicalMenus = Cache::remember('hierarchical_menus', 3600, function () {
                return $this->buildMenuHierarchy();
            });

            $view->with('menus', $hierarchicalMenus);
        } catch (\Exception $e) {
            $simpleMenus = Menu::active()->orderBy('order', 'asc')->get();

            $view->with('menus', $simpleMenus);
        }
    }

    private function buildMenuHierarchy()
    {
        $parentMenus = Menu::with('children')->active()->whereNull('parent_id')->orderBy('order', 'asc')->get();

        if ($parentMenus->isEmpty()) {
            return collect([]);
        }

        return $parentMenus;
    }
}