<?php

namespace App\Services\Dashboard;

use App\Models\SiteAddress;
use Illuminate\Support\Facades\DB;

class SiteAddressService
{
    /**
     * Create a new class instance.
     */
    public function store($data)
    {
        DB::beginTransaction();

        try {
            // Handle multilingual fields - convert from separate fields to JSON
            $multilingualFields = ['title', 'address'];
            foreach ($multilingualFields as $field) {
                if (isset($data[$field . '_en']) || isset($data[$field . '_ar'])|| isset($data[$field . '_fr'])) {
                    $fieldData = [];
                    if (isset($data[$field . '_en'])) {
                        $fieldData['en'] = $data[$field . '_en'];
                        unset($data[$field . '_en']);
                    }
                    if (isset($data[$field . '_ar'])) {
                        $fieldData['ar'] = $data[$field . '_ar'];
                        unset($data[$field . '_ar']);
                    }
                     if (isset($data[$field . '_fr'])) {
                        $fieldData['fr'] = $data[$field . '_fr'];
                        unset($data[$field . '_fr']);
                    }
                    $data[$field] = json_encode($fieldData, JSON_UNESCAPED_UNICODE);
                }
            }

            // Combine country code with phone numbers
            if (isset($data['code']) && isset($data['phone'])) {
                $data['phone'] = $data['code'] . $data['phone'];
                unset($data['code']); // Remove code after combining
            }

            if (isset($data['code2']) && isset($data['phone2'])) {
                $data['phone2'] = $data['code2'] . $data['phone2'];
                unset($data['code2']); // Remove code2 after combining
            }

            // Create the SiteAddress
            SiteAddress::create($data);

            DB::commit();

            return true;
        } catch (\Exception $e) {

            DB::rollBack();

            throw $e;
        }
    }

    public function update($data, $site_address)
    {
        DB::beginTransaction();

        try {
            // Handle multilingual fields - convert from separate fields to JSON
            $multilingualFields = ['title', 'address'];
            foreach ($multilingualFields as $field) {
                if (isset($data[$field . '_en']) || isset($data[$field . '_ar']) || isset($data[$field . '_fr'])) {
                    $fieldData = [];
                    if (isset($data[$field . '_en'])) {
                        $fieldData['en'] = $data[$field . '_en'];
                        unset($data[$field . '_en']);
                    }
                    if (isset($data[$field . '_ar'])) {
                        $fieldData['ar'] = $data[$field . '_ar'];
                        unset($data[$field . '_ar']);
                    }
                    if (isset($data[$field . '_fr'])) {
                        $fieldData['fr'] = $data[$field . '_fr'];
                        unset($data[$field . '_fr']);
                    }
                    $data[$field] = json_encode($fieldData, JSON_UNESCAPED_UNICODE);
                }
            }

            $data['status'] = $data['status'] ?? 0;

            // Combine country code with phone numbers
            if (isset($data['code']) && isset($data['phone'])) {
                $data['phone'] = $data['code'] . $data['phone'];
                unset($data['code']); // Remove code after combining
            }

            if (isset($data['code2']) && isset($data['phone2'])) {
                $data['phone2'] = $data['code2'] . $data['phone2'];
                unset($data['code2']); // Remove code2 after combining
            }


            $site_address->update($data);
            DB::commit();
            return true;
        } catch (\Exception $e) {
            DB::rollBack();
            throw $e;
        }
    }

    public function delete($selectedIds)
    {


        DB::beginTransaction();
        try {

            $deleted = SiteAddress::whereIn('id', $selectedIds)->delete();

            DB::commit();

            return $deleted > 0;
        } catch (\Exception $e) {

            DB::rollBack();

            return false;
        }
    }
}
