<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use Illuminate\Support\Facades\Mail;
use App\Models\Setting;

class TestContactEmail extends Command
{
    protected $signature = 'test:contact-email {email?}';
    protected $description = 'Test contact form email notification';

    public function handle()
    {
        $testEmail = $this->argument('email') ?? 'info@dhiegypt.com';

        $this->info('🧪 Testing Contact Form Email...');
        $this->info('Target Email: ' . $testEmail);

        try {
            // Build test email content
            $htmlContent = $this->buildTestEmailTemplate();

            // Send test email
            Mail::html($htmlContent, function ($mail) use ($testEmail) {
                $mail->to($testEmail)
                    ->subject("🧪 Test Email - DHI Contact Form");
            });

            $this->info('✅ Email sent successfully!');
            $this->info('📬 Check your inbox: ' . $testEmail);

            // Show mail configuration
            $this->newLine();
            $this->warn('Current Mail Configuration:');
            $this->table(
                ['Setting', 'Value'],
                [
                    ['MAIL_MAILER', config('mail.default')],
                    ['MAIL_HOST', config('mail.mailers.smtp.host')],
                    ['MAIL_PORT', config('mail.mailers.smtp.port')],
                    ['MAIL_FROM', config('mail.from.address')],
                ]
            );
        } catch (\Exception $e) {
            $this->error('❌ Failed to send email!');
            $this->error('Error: ' . $e->getMessage());

            // Show detailed error log
            $this->newLine();
            $this->warn('Check logs at: storage/logs/laravel.log');

            return 1;
        }

        return 0;
    }

    protected function buildTestEmailTemplate()
    {
        return "<!DOCTYPE html>
<html dir='rtl' lang='ar'>
<head>
    <meta charset='UTF-8'>
    <style>
        body { font-family: Arial, sans-serif; direction: rtl; background: #f4f4f4; padding: 20px; }
        .container { max-width: 600px; margin: 0 auto; background: white; border-radius: 8px; overflow: hidden; box-shadow: 0 2px 4px rgba(0,0,0,0.1); }
        .header { background: #164852; color: white; padding: 30px; text-align: center; }
        .content { padding: 30px; }
        .success { background: #d4edda; border: 1px solid #c3e6cb; color: #155724; padding: 15px; border-radius: 4px; margin: 20px 0; }
        .info { background: #d1ecf1; border: 1px solid #bee5eb; color: #0c5460; padding: 15px; border-radius: 4px; }
    </style>
</head>
<body>
    <div class='container'>
        <div class='header'>
            <h1>🧪 اختبار نظام البريد الإلكتروني</h1>
        </div>
        <div class='content'>
            <div class='success'>
                <h2>✅ نجح الاختبار!</h2>
                <p>إذا وصلتك هذه الرسالة، معناه أن نظام إرسال الإيميلات يعمل بشكل صحيح.</p>
            </div>
            
            <div class='info'>
                <h3>📋 تفاصيل الاختبار:</h3>
                <p><strong>الموقع:</strong> DHI Egypt</p>
                <p><strong>التاريخ:</strong> " . date('Y-m-d H:i:s') . "</p>
                <p><strong>النظام:</strong> Laravel Mail System</p>
            </div>
            
            <p style='margin-top: 30px; color: #666; font-size: 14px;'>
                الآن يمكنك استخدام نموذج التواصل على الموقع وستصلك الإيميلات بنفس هذا التنسيق.
            </p>
        </div>
    </div>
</body>
</html>";
    }
}
