<script>
$(document).on('click', '.btn-add-to-cart', function(e) {

     e.preventDefault(); // This prevents the form from submitting normally

    var $btn = $(this);
    var productId = $btn.data('product_id');
    var $form = $('#variant-form');
    var quantity = Number(document.querySelector('.quantity-product')?.value) || 1;

    // Collect selected variants
    var selectedVariants = {};

    $form.find('input[type=radio]:checked').each(function() {
        var name = $(this).attr('name');
        var attributeId = name.match(/\[(\d+)\]/)[1];
        selectedVariants[attributeId] = $(this).val();
    });

    $.ajax({
        url: "<?php echo e(route('addToCart')); ?>",
        method: 'POST',
        headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        },
        data: {
            productId: productId,
            quantity: quantity,
            variants: selectedVariants
        },
        beforeSend: function() {
            $btn.prop('disabled', true).addClass('loading');
        },
        complete: function() {
            $btn.prop('disabled', false).removeClass('loading');
        },
        success: function(response) {
            if (response.status === true) {
                // Update UI
                $('#shoppingCart').modal('show');
                $('.tf-mini-cart-wrap').html(response.html);
                $('.cartCount').text(response.cartItemsCount);

                toastr.success(response.message);

            } else if (response.status === false) {
                toastr.error(response.message || 'Failed to add to cart');
                  $('#shoppingCart').modal('hide');
            }
        },
        error: function(xhr) {
            if (xhr.status === 422) {
                // Laravel validation errors
                var errors = xhr.responseJSON.errors;
                $.each(errors, function(key, value) {
                    toastr.error(value[0]);
                });
            } else if (xhr.status === 401) {
                window.location.href = "<?php echo e(route('login')); ?>";
            } else {
                toastr.error(xhr.responseJSON?.message || 'An error occurred. Please try again.');
            }
        }
    });
});

</script>
<?php /**PATH /home/webtest3/public_html/naguib-selim/resources/views/website/scripts/cart/addToCart.blade.php ENDPATH**/ ?>