<?php $__env->startSection('meta'); ?>
    <title>
        <?php echo e(trans('home.edit_product')); ?>

    </title>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <div class="container-fluid">
        <!-- Page Header -->
        <div class="page-header">
            <div>
                <h2 class="main-content-title tx-24 mg-b-5"><?php echo e(trans('home.products')); ?></h2>
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="<?php echo e(url('/admin')); ?>"><?php echo e(trans('home.admin')); ?></a></li>
                    <li class="breadcrumb-item"><a href="<?php echo e(url('admin/products')); ?>"><?php echo e(trans('home.products')); ?></a></li>
                    <li class="breadcrumb-item active" aria-current="page"><?php echo e(trans('home.edit_product')); ?></li>
                </ol>
            </div>
            <div class="btn btn-list">
                <a href="<?php echo e(route('products.variants.index', $product->id)); ?>">
                    <button class="btn ripple btn-warning">
                        <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-diagram-3-fill" viewBox="0 0 16 16">
                            <path fill-rule="evenodd" d="M6 3.5A1.5 1.5 0 0 1 7.5 2h1A1.5 1.5 0 0 1 10 3.5v1A1.5 1.5 0 0 1 8.5 6v1H14a.5.5 0 0 1 .5.5v1a.5.5 0 0 1-1 0V8h-5v.5a.5.5 0 0 1-1 0V8h-5v.5a.5.5 0 0 1-1 0v-1A.5.5 0 0 1 2 7h5.5V6A1.5 1.5 0 0 1 6 4.5zm-6 8A1.5 1.5 0 0 1 1.5 10h1A1.5 1.5 0 0 1 4 11.5v1A1.5 1.5 0 0 1 2.5 14h-1A1.5 1.5 0 0 1 0 12.5zm6 0A1.5 1.5 0 0 1 7.5 10h1a1.5 1.5 0 0 1 1.5 1.5v1A1.5 1.5 0 0 1 8.5 14h-1A1.5 1.5 0 0 1 6 12.5zm6 0a1.5 1.5 0 0 1 1.5-1.5h1a1.5 1.5 0 0 1 1.5 1.5v1a1.5 1.5 0 0 1-1.5 1.5h-1a1.5 1.5 0 0 1-1.5-1.5z"/>
                          </svg>
                        <?php echo e(trans('home.variants')); ?>

                    </button>
                </a>

                <a href="<?php echo e(route('products.images.index', $product->id)); ?>" >
                    <button class="btn ripple btn-danger">
                        <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-images" viewBox="0 0 16 16">
                            <path d="M4.502 9a1.5 1.5 0 1 0 0-3 1.5 1.5 0 0 0 0 3"/>
                            <path d="M14.002 13a2 2 0 0 1-2 2h-10a2 2 0 0 1-2-2V5A2 2 0 0 1 2 3a2 2 0 0 1 2-2h10a2 2 0 0 1 2 2v8a2 2 0 0 1-1.998 2M14 2H4a1 1 0 0 0-1 1h9.002a2 2 0 0 1 2 2v7A1 1 0 0 0 15 11V3a1 1 0 0 0-1-1M2.002 4a1 1 0 0 0-1 1v8l2.646-2.354a.5.5 0 0 1 .63-.062l2.66 1.773 3.71-3.71a.5.5 0 0 1 .577-.094l1.777 1.947V5a1 1 0 0 0-1-1z"/>
                        </svg>
                        <?php echo e(trans('home.product_images')); ?>

                    </button>
                </a>

                 <a href="<?php echo e(route('products.discounts.index', $product->id)); ?>">
                    <button class="btn ripple btn-dark">
                        <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-percent" viewBox="0 0 16 16">
                            <path d="M13.442 2.558a.625.625 0 0 1 0 .884l-10 10a.625.625 0 1 1-.884-.884l10-10a.625.625 0 0 1 .884 0M4.5 6a1.5 1.5 0 1 1 0-3 1.5 1.5 0 0 1 0 3m0 1a2.5 2.5 0 1 0 0-5 2.5 2.5 0 0 0 0 5m7 6a1.5 1.5 0 1 1 0-3 1.5 1.5 0 0 1 0 3m0 1a2.5 2.5 0 1 0 0-5 2.5 2.5 0 0 0 0 5"/>
                        </svg>
                        <?php echo e(trans('home.discounts')); ?>

                    </button>
                 </a>
            </div>
        </div>


        <!-- End Page Header -->


        <!-- Row-->
        <form action="<?php echo e(route('products.update',$product->id)); ?>" method="POST" enctype="multipart/form-data">
            <?php echo csrf_field(); ?>
            <?php echo method_field('PATCH'); ?>
            <div class="card p-3 mb-3">
                <div class="row ">
                    <div class="mb-3 col-12">
                        <h6 class="card-title mb-1"><?php echo e(trans('home.product_main_info')); ?></h6>
                    </div>

                    <div class="form-group col-md-6">
                        <label><?php echo e(trans('home.name_en')); ?></label>
                        <input class="form-control" name="name_en" value="<?php echo e($product->name_en); ?>" type="text"  placeholder="<?php echo e(trans('home.name_en')); ?>" required>
                    </div>

                    <div class="form-group col-md-6">
                        <label><?php echo e(trans('home.name_ar')); ?></label>
                        <input class="form-control" name="name_ar" value="<?php echo e($product->name_ar); ?>" type="text" placeholder="<?php echo e(trans('home.name_ar')); ?>" required>
                    </div>

                    <div class="form-group col-md-3">
                        <label><?php echo e(trans('home.code')); ?></label>
                        <input class="form-control" name="code" value="<?php echo e($product->code); ?>" type="text"  placeholder="<?php echo e(trans('home.code')); ?>" >
                    </div>
                    <div class="form-group col-md-3">
                        <labe><?php echo e(trans('home.category')); ?></labe>
                        <select class="form-control select2" name="category_id">
                            <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($category->id); ?>" <?php if($product->category_id == $category->id): echo 'selected'; endif; ?>>
                                    <?php echo e($category->name); ?>

                                </option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>
                    <div class="form-group col-md-3">
                        <label><?php echo e(trans('home.brands')); ?></label>
                        <select class="form-control select2" name="brand_id">
                            <?php $__currentLoopData = $brands; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $brand): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($brand->id); ?>" <?php if($product->brang_id == $brand->id): echo 'selected'; endif; ?>>
                                    <?php echo e($brand->name); ?>

                                </option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>
                    <div class="form-group col-md-3">
                        <label><?php echo e(trans('home.order')); ?></label>
                        <input class="form-control" name="order" value="<?php echo e($product->order); ?>" type="number" min="1" step="1"  placeholder="<?php echo e(trans('home.order')); ?>" >
                    </div>

                    <div class="form-group col-md-6">
                        <label><?php echo e(trans('home.price')); ?></label>
                        <input class="form-control" name="price" value="<?php echo e($product->price); ?>" type="text" placeholder="<?php echo e(trans('home.price')); ?>" >
                    </div>

                    <div class="form-group col-md-6">
                        <label><?php echo e(trans('home.quantity')); ?></label>
                        <input class="form-control" name="quantity" value="<?php echo e($product->quantity); ?>" type="number" placeholder="<?php echo e(trans('home.quantity')); ?>" >
                    </div>

                    <div class="form-group col-md-12">
                        <label for="helperText"><?php echo e(trans('home.attributes')); ?></label>
                        <select id="select-attribute"  class="form-control role select2" name="attributes[]" multiple>
                            <?php $__currentLoopData = $attributes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $attribut): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option <?php if(in_array( $attribut->id, $product->attributes->pluck('attribute_id')->toArray())): echo 'selected'; endif; ?> value="<?php echo e($attribut->id); ?>" ><?php echo e($attribut->name); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>

                    <div class="col-md-6">
                        <label><?php echo e(trans('home.main_image')); ?> (50px  * 50px max 1mb)</label>
                        <div class="input-group mb-1">
                            <div class="input-group-prepend">
                                <span class="input-group-text"> <?php echo e(trans('home.upload')); ?></span>
                            </div>
                            <div class="custom-file">
                                <input type="file" class="custom-file-input" name="main_image">
                                <label class="custom-file-label" for="inputGroupFile01"><?php echo e(trans('home.choose_image')); ?></label>
                            </div>
                        </div>
                    </div>

                    <div class="col-md-6">
                        <label><?php echo e(trans('home.second_image')); ?> (50px  * 50px max 1mb)</label>
                        <div class="input-group mb-1">
                            <div class="input-group-prepend">
                                <span class="input-group-text"> <?php echo e(trans('home.upload')); ?></span>
                            </div>
                            <div class="custom-file">
                                <input type="file" class="custom-file-input" name="second_image">
                                <label class="custom-file-label" for="inputGroupFile01"><?php echo e(trans('home.choose_image')); ?></label>
                            </div>
                        </div>
                    </div>
                    <div class="row col-12">
                        <div class="col-md-6">
                            <img src="<?php echo e($product->main_image_path); ?>" width="150">
                        </div>
                        <div class="col-md-6">
                            <img src="<?php echo e($product->second_image_path); ?>" width="150">
                        </div>
                    </div>

                    <div class="form-group col-md-6">
                        <label><?php echo e(trans('home.alt_main_image')); ?></label>
                        <input class="form-control" name="alt_main_image" value="<?php echo e($product->alt_main_image); ?>" type="text"  placeholder="<?php echo e(trans('home.alt_main_image')); ?>" >
                    </div>
                    <div class="form-group col-md-6">
                        <label><?php echo e(trans('home.alt_second_image')); ?></label>
                        <input class="form-control" name="alt_second_image" value="<?php echo e($product->alt_second_image); ?>" type="text"  placeholder="<?php echo e(trans('home.alt_main_image')); ?>" >
                    </div>

                    <div class="form-group col-md-6">
                        <label> <?php echo e(trans('home.short_text_en')); ?></label>
                        <textarea class="form-control" name="short_text_en"><?php echo $product->short_text_en; ?></textarea>
                    </div>
                    <div class="form-group col-md-6">
                        <label> <?php echo e(trans('home.short_text_ar')); ?></label>
                        <textarea class="form-control" name="short_text_ar"><?php echo $product->short_text_ar; ?></textarea>
                    </div>
                    <div class="form-group col-md-6">
                        <label> <?php echo e(trans('home.text_en')); ?></label>
                        <textarea class="area1" name="text_en"><?php echo $product->text_en; ?></textarea>
                    </div>
                    <div class="form-group col-md-6">
                        <label> <?php echo e(trans('home.text_ar')); ?></label>
                        <textarea class="area1" name="text_ar"><?php echo $product->text_ar; ?></textarea>
                    </div>
                    <div class="form-group col-md-4">
                        <label class="ckbox">
                            <input name="status" value="1" <?php echo e(($product->status == 1)? 'checked':''); ?> type="checkbox"><span class="tx-13"><?php echo e(trans('home.publish')); ?></span>
                        </label>

                    </div>
                    <div class="form-group col-md-4">
                        <label class="ckbox">
                            <input name="featured" value="1" <?php echo e(($product->featured == 1)? 'checked':''); ?> type="checkbox"><span class="tx-13"><?php echo e(trans('home.featured')); ?></span>
                        </label>
                    </div>
                    <div class="form-group col-md-4">
                        <label class="ckbox">
                            <input name="home" value="1" <?php echo e(($product->home == 1)? 'checked':''); ?> type="checkbox"><span class="tx-13"><?php echo e(trans('home.home')); ?></span>
                        </label>
                    </div>
                </div>
            </div>

            <div class="card p-3 mb-3">
                <div class="row ">
                    <div class="mb-3 col-12">
                        <h6 class="card-title mb-1"><?php echo e(trans('home.seo')); ?></h6>
                    </div>

                    <div class="form-group col-md-12">
                        <hr>
                        <span class="badge badge-success"><?php echo e(trans('home.en')); ?></span>
                    </div>
                    <div class="form-group col-md-2">
                        <label for="name_ar"><?php echo e(trans('home.link_en')); ?></label>
                        <input type="text" autocomplete="off"  value="<?php echo e($product->link_en); ?>"  class="form-control" placeholder="<?php echo e(trans('home.link_en')); ?>" name="link_en">
                    </div>

                    <div class="form-group col-md-5">
                        <label for="meta_title"> <?php echo e(trans('home.meta_title_en')); ?></label>
                        <textarea class="form-control"  value="<?php echo e($product->meta_title_en); ?>" name="meta_title_en" placeholder="<?php echo e(trans('home.meta_title_en')); ?>"></textarea>
                    </div>

                    <div class="form-group col-md-5">
                        <label for="meta_desc"> <?php echo e(trans('home.meta_desc_en')); ?></label>
                        <textarea class="form-control"  value="<?php echo e($product->meta_desc_en); ?>" name="meta_desc_en" placeholder="<?php echo e(trans('home.meta_desc_en')); ?>"></textarea>
                    </div>

                    <div class="form-group col-md-12">
                        <hr>
                        <span class="badge badge-success"><?php echo e(trans('home.ar')); ?></span>
                    </div>

                    <div class="form-group col-md-2">
                        <label for="name_ar"><?php echo e(trans('home.link_ar')); ?></label>
                        <input type="text" autocomplete="off"  value="<?php echo e($product->link_ar); ?>"  class="form-control" placeholder="<?php echo e(trans('home.link_ar')); ?>" name="link_ar">
                    </div>

                    <div class="form-group col-md-5">
                        <label for="meta_title"> <?php echo e(trans('home.meta_title_ar')); ?></label>
                        <textarea class="form-control"  name="meta_title_ar" value="<?php echo e($product->meta_title_ar); ?>" placeholder="<?php echo e(trans('home.meta_title_ar')); ?>"></textarea>
                    </div>

                    <div class="form-group col-md-5">
                        <label for="meta_desc"> <?php echo e(trans('home.meta_desc_ar')); ?></label>
                        <textarea class="form-control" name="meta_desc_ar"  value="<?php echo e($product->meta_desc_ar); ?>" placeholder="<?php echo e(trans('home.meta_desc')); ?>"></textarea>
                    </div>

                    <div class="form-group col-md-12">
                        <label class="ckbox">
                            <input name="meta_robots" value="1" <?php if($product->meta_robots): echo 'checked'; endif; ?> type="checkbox"><span class="tx-13"><?php echo e(trans('home.meta_robots')); ?> (index)</span>
                        </label>
                    </div>
                </div>
            </div>

            <div class="row">
                <div class="form-group col-md-12">
                    <button type="submit" class="btn btn-success"> <?php echo e(trans('home.save')); ?> </button>
                    <a href="<?php echo e(url('/admin/products')); ?>"><button type="button" class="btn btn-danger mr-1"><i
                                class="icon-trash"></i> <?php echo e(trans('home.cancel')); ?></button></a>
                </div>
            </div>
        </form>
    </div>


<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/webtest3/public_html/naguib-selim/resources/views/admin/products/edit.blade.php ENDPATH**/ ?>