<?php $__env->startSection('meta'); ?>
    <title><?php echo e(trans('home.admin_panel')); ?></title>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>

<div class="container-fluid">

	<!-- Page Header -->
	<div class="page-header">
		<div>
			<h2 class="main-content-title tx-24 mg-b-5"><?php echo e(trans('home.Welcome To Dashboard')); ?></h2>
		</div>
	</div>
	<!-- End Page Header -->

	<!-- Row -->
	<div class="row row-sm">
		<?php $__currentLoopData = $reports; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
		<div class="col-sm-6 col-xl-2 col-lg-6">
			<div class="card custom-card">
				<div class="card-body dash1">
					<div class="d-flex">
						<p class="mb-1 tx-inverse"><?php echo e($key); ?></p>
						
					</div>
					<div>
						<h3 class="dash-25"><?php echo e($value); ?></h3>
					</div>
					<div class="progress mb-1">
						<?php
							$bg = [
									'bg-primary',
									'bg-secondary',
									'bg-success',
									'bg-danger',
									'bg-warning',
									'bg-info',
									
									'bg-dark',
								
									
								];

						?>
						<div aria-valuemax="100" aria-valuemin="0" aria-valuenow="70" class="progress-bar <?php echo e($bg[array_rand($bg)]); ?> progress-bar-xs wd-70p" role="progressbar"></div>
					</div>
					<div class="expansion-label d-flex">
						<span class="text-muted"><?php echo e(trans("home.$key")); ?></span>
						<span class="ml-auto"><?php echo e($value); ?></span>
					</div>
				</div>
			</div>
		</div>
		<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
	</div>
	<!--End  Row -->

	<!-- Row-->
	<div class="row">
		<div class="col-sm-12 col-xl-12 col-lg-12">
			<div class="card custom-card">
				<div class="card-body">
					<div>
						<h6 class="card-title mb-1"><?php echo e(trans('home.Orders Summary')); ?></h6>
						<p class="text-muted card-sub-title"><?php echo e(trans('home.list of recent 10 orders')); ?></p>
					</div>
					<div class="table-responsive">
						<table class="table table-bordered text-nowrap mb-0">
							<thead>
								<tr>
									<th>#No</th>
									<th><?php echo e(trans('home.order_number')); ?></th>
									<th><?php echo e(trans('home.order_date')); ?></th>
									<th><?php echo e(trans('home.order_user')); ?></th>
									<th><?php echo e(trans('home.order_address')); ?></th>
									<th><?php echo e(trans('home.order_note')); ?></th>
									<th><?php echo e(trans('home.order_phone_numbers')); ?></th>
									<th><?php echo e(trans('home.order_status')); ?></th>
								</tr>
							</thead>
							<tbody>

								<?php $__currentLoopData = $orders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$order): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
									<tr>
										<td><?php echo e($key+1); ?></td>
										<td><?php echo e($order->order_number); ?></td>
										<td><?php echo e(date('Y-m-d', strtotime($order->created_at ))); ?></td>
										<td><?php echo e($order->user->name); ?></td>
										<td><?php echo e($order->address->full_address); ?></td>
										<td><?php echo e($order->note); ?></td>
										<td><?php echo e($order->address->phone); ?></td>
										<td>
											<span class="badge badge-primary"><?php echo e($order->status?->name); ?></span>
										</td>
									</tr>
								<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

							</tbody>
						</table>
					</div>
				</div>
			</div>
		</div>
	</div>
	<!-- End Row -->

</div>



<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/webtest3/public_html/naguib-selim/resources/views/admin/index.blade.php ENDPATH**/ ?>