<?php $__env->startSection('meta'); ?>

<?php echo $metatags ?>
<?php echo $schema ?>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>

<?php echo $__env->make('website.product-partials._breadcrumb', ['page_title' => $product->name], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<section class="flat-spacing-4 pt-0">
    <div class="tf-main-product section-image-zoom">
        <div class="container">
            <div class="row" id="product-section">
                <div class="col-md-6">
                    <div class="tf-product-media-wrap sticky-top">
                        
                        <?php echo $__env->make('website.product-partials._product-media', [
                        'product' => $product,
                        'images' => $product->variants->isNotEmpty() ? $product->default_variant->images :
                        $product->images,
                        'mainImage' => $product->main_image_path,
                        'mainImageAlt' => $product->alt_main_image
                        ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    </div>
                </div>
                
                <div class="col-md-6">
                    <div class="tf-product-info-wrap position-relative">
                        <div class="tf-zoom-main"></div>
                        <div class="tf-product-info-list other-image-zoom">
                            <div class="tf-product-info-title">
                                <h5><?php echo e($product->name); ?></h5>
                            </div>



                            
                            <?php echo $__env->make('website.product-partials._product-pricing', [
                            'product' => $product,
                            'variantId' => $product->default_variant?->id
                            ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

                            
                            <?php if($product->viewing_count > 3): ?>
                            <div class="tf-product-info-liveview">
                                <div class="liveview-count"><?php echo e($product->viewing_count); ?></div>
                                <p class="fw-6">People are viewing this right now</p>
                            </div>
                            <?php endif; ?>

                            
                            <div class="tf-product-info-liveview">
                                <p class="fw-6"><?php echo e($product->short_text); ?></p>
                            </div>


                            
                            <?php if($product->has_variants): ?>
                            <?php echo $__env->make('website.product-partials._variant-selector', [
                            'product' => $product
                            ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                            <?php endif; ?>

                            
                            <div class="tf-product-info-quantity">
                                <div class="quantity-title fw-6">Quantity</div>
                                <div class="wg-quantity">
                                    <span class="btn-quantity btn-decrease">-</span>
                                    <input type="text" class="quantity-product" name="quantity" value="1">
                                    <span class="btn-quantity btn-increase">+</span>
                                </div>
                            </div>

                            

                        <div class="tf-product-info-buy-button">
                            <button type="button"
                                    class="tf-btn btn-fill justify-content-center fw-6 fs-16 flex-grow-1 animate-hover-btn btn-add-to-cart"
                                    data-product_id="<?php echo e($product->id); ?>"
                                    <?php if($product->isInStock() == false): echo 'disabled'; endif; ?>
                                    title="<?php echo e($product->isInStock() == false ? 'Out of stock' : 'Add to cart'); ?>">
                                <span><?php echo e($product->isInStock() == false ? 'Out of stock' : 'Add to cart'); ?></span>
                            </button>
                            <button type="button"
                                    data-product_id="<?php echo e($product->id); ?>"
                                    class="tf-btn btn-fill justify-content-center fw-6 fs-16 flex-grow-1 animate-hover-btn btn-add-to-sample-request">
                                    <span><?php echo e(__('home.Add sample Request')); ?></span>
                            </button>
                            <button type="button"
                                    class="tf-product-btn-wishlist hover-tooltip box-icon bg_white wishlist btn-icon-action">
                                <span class="icon icon-heart"></span>
                                <span class="tooltip">Add to Wishlist</span>
                                <span class="icon icon-delete"></span>
                            </button>
                        </div>

                            

                            
                            <?php echo $__env->make('website.product-partials._extra-links', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

                            
                            <?php echo $__env->make('website.product-partials._delivery-return', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

                            
                            <?php echo $__env->make('website.product-partials._trust-seal', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

                        </div>
                    </div>
                </div>
            </div>
        </div>
</section>

        <?php echo $__env->make('website.product-partials._tabs', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>;



        
        <?php if($relatedProducts->isNotEmpty()): ?>
               <?php echo $__env->make('website.product-partials._related-products', ['relatedProducts' => $relatedProducts], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <?php endif; ?>




<?php $__env->stopSection(); ?>

<?php $__env->startSection('script'); ?>
<script>
    $(document).ready(function() {
        // Initialize Swiper
        let thumbsSwiper = null;
        let mainSwiper = null;

        function initializeSwiper() {
            thumbsSwiper = new Swiper('.tf-product-media-thumbs', {
                direction: 'vertical'
                , slidesPerView: 'auto'
                , spaceBetween: 10
                , watchSlidesVisibility: true
                , watchSlidesProgress: true
            });
            mainSwiper = new Swiper('.tf-product-media-main', {
                slidesPerView: 1
                , spaceBetween: 10
                , thumbs: {
                    swiper: thumbsSwiper
                }
                , navigation: {
                    nextEl: '.thumbs-next'
                    , prevEl: '.thumbs-prev'
                }
            });
        }
        if ($('.tf-product-media-thumbs').length) {
            initializeSwiper();
        }

        // Function to bind variant change listener
        function bindVariantChangeListener() {
            $('input[name^="variant["]').off('change').on('change', function() {
                const form = $('#variant-form');
                const selectedValue = $(this).data('value');
                const attributeName = $(this).data('attribute');

                // Update label immediately
                $('.value-current-' + attributeName.toLowerCase()).text(selectedValue);

                const formData = form.serialize(); // Includes product_id, variant[attribute_id], number

                $.ajax({
                    url: form.attr('action')
                    , type: form.attr('method')
                    , data: formData
                    , dataType: 'json'
                    , success: function(response) {
                        if (response.error) {
                            console.error(response.error);
                            alert(response.error);
                            return;
                        }

                        // Update price display
                        updatePriceDisplay(response.variant);

                        // Update stock status
                        updateStockStatus(response.variant);



                        // Update attributes
                        if (response.variant.attributes) {
                            Object.keys(response.variant.attributes).forEach(attr => {
                                $('.value-current-' + attr.toLowerCase()).text(response.variant.attributes[attr]);
                            });
                        }

                        // Update images
                        if (response.variant.images && response.variant.images.length > 0) {

                            updateProductImages(response.variant.images);
                        }
                    }
                    , error: function(xhr, status, error) {

                        toastr.error(error);
                    }
                });
            });
        }

        function updatePriceDisplay(variant) {
            const priceContainer = $('.product-pricing');

            if (variant.is_on_sale) {
                priceContainer.html(`
                    <span class="sale-price">${variant.sale_price}</span>
                    <span class="original-price">
                        <del>${variant.price}</del>
                    </span>
                `);
            } else {
                priceContainer.html(`<span class="price">${variant.price}</span>`);
            }

            if (variant.is_on_sale) {
                priceContainer.html(`
                    <div class="sale-price">
                        <strong>Now:</strong> ${variant.currency} ${variant.sale_price}
                    </div>
                    <div class="original-price">
                        <strong>Before sale price:</strong>
                        <del>${variant.currency} ${variant.price}</del>
                    </div>
                    <div class="save-discount">
                        <strong>Save:</strong> ${variant.currency} ${variant.discount_amount}
                    </div>
                `);
                        } else {
                            priceContainer.html(`
                    <span class="price">
                        ${variant.currency} ${variant.price}
                    </span>
                `);
            }
            // Also update any other price elements that might exist
            $('.price-on-sale, .current-price').text(variant.sale_price || variant.price);
        }
        // Function to update product images
        function updateProductImages(images) {


            // Clear existing slides
            $('.tf-product-media-thumbs .swiper-wrapper').empty();
            $('.tf-product-media-main .swiper-wrapper').empty();

            // Add new slides
            images.forEach(image => {
                $('.tf-product-media-thumbs .swiper-wrapper').append(`
                <div class="swiper-slide stagger-item">
                    <div class="item">
                        <img class="lazyload" data-src="${image.src}" src="${image.src}" alt="${image.alt}">
                    </div>
                </div>
            `);
                $('.tf-product-media-main .swiper-wrapper').append(`
                <div class="swiper-slide">
                    <a href="${image.src}" target="_blank" class="item" data-pswp-width="770px" data-pswp-height="1075px">
                        <img class="tf-image-zoom lazyload" data-zoom="${image.src}"
                             data-src="${image.src}" src="${image.src}" alt="${image.alt}">
                    </a>
                </div>
            `);
            });

            // Reinitialize Swiper
            if (thumbsSwiper && mainSwiper) {
                thumbsSwiper.destroy(true, true);
                mainSwiper.destroy(true, true);
            }
            initializeSwiper();
        }

        // Function to bind quantity button listeners
        function bindQuantityListeners() {
            $('.btn-increase').off('click').on('click', function() {
                const input = $('.quantity-product');
                const value = parseInt(input.val());
                input.val(value + 1);
            });
            $('.btn-decrease').off('click').on('click', function() {
                const input = $('.quantity-product');
                const value = parseInt(input.val());
                if (value > 1) {
                    input.val(value - 1);
                }
            });
        }

        // Function to update stock status
        function updateStockStatus(variant) {

            const stockStatus = $('.stock-status');
            const addToCartButton = $('.btn-add-to-cart');
            const addToCartText = addToCartButton.find('span');

            if (variant.in_stock) {
                stockStatus.text('In Stock').removeClass('out-of-stock').addClass('in-stock');
                addToCartButton.prop('disabled', false).attr('title', 'Add to cart');
                addToCartText.text('Add to cart');
            } else {
                stockStatus.text('Out of Stock').removeClass('in-stock').addClass('out-of-stock');
                addToCartButton.prop('disabled', true).attr('title', 'Out of stock');
                addToCartText.text('Out of stock');
            }
        }

        // Initial binding
        bindVariantChangeListener();
        bindQuantityListeners();


    });

</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/webtest3/public_html/naguib-selim/resources/views/website/product-details.blade.php ENDPATH**/ ?>