<title><?php echo e(trans('home.edit_slider')); ?></title>
<?php $__env->startSection('content'); ?>

<div class="container-fluid">

        <!-- Page Header -->
        <div class="page-header">
            <div>
                <h2 class="main-content-title tx-24 mg-b-5"><?php echo e(trans('home.sliders')); ?></h2>
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="<?php echo e(url('/admin')); ?>"><?php echo e(trans('home.admin')); ?></a></li>
                    <li class="breadcrumb-item"><a href="<?php echo e(url('admin/sliders')); ?>"><?php echo e(trans('home.sliders')); ?></a></li>
                    <li class="breadcrumb-item active" aria-current="page"><?php echo e(trans('home.edit_slider')); ?></li>
                </ol>
            </div>
        </div>
        <!-- End Page Header -->

        <!-- Row-->
        <div class="row">
            <div class="col-sm-12 col-xl-12 col-lg-12">
                <div class="card custom-card overflow-hidden">

                    <div class="card-body">
                        <div>
                            <h6 class="card-title mb-1"><?php echo e(trans('home.edit_slider')); ?></h6>
                        </div>
                    <form action="<?php echo e(route('sliders.update', $slider->id)); ?>" method="POST" enctype="multipart/form-data">
                        <?php echo csrf_field(); ?>
                        <?php echo method_field('PUT'); ?>
                            <div class="row">

                                <div class="form-group col-md-3">
                                    <label class=""><?php echo e(trans('home.title_en')); ?></label>
                                    <input class="form-control" name="title_en" type="text" placeholder="<?php echo e(trans('home.title_en')); ?>" value="<?php echo e($slider->title_en); ?>">
                                </div>
                                <div class="form-group col-md-3">
                                    <label class=""><?php echo e(trans('home.title_ar')); ?></label>
                                    <input class="form-control" name="title_ar" type="text" placeholder="<?php echo e(trans('home.title_ar')); ?>" value="<?php echo e($slider->title_ar); ?>">
                                </div>

                                <div class="form-group col-md-2">
                                    <label for="parent"><?php echo e(trans('home.type')); ?></label>
                                    <select class="form-control select2 parent" name="type">
                                        <option value="home">Select Type</option>
        
                                    <?php $__currentLoopData = App\Models\Slider::TYPES; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $type): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($type); ?>" <?php echo e($slider->type == $type ? 'selected' : ''); ?>><?php echo e($type); ?></option>
                                        
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                </div>

                                <div class="form-group col-md-4">
                                    <label class=""><?php echo e(trans('home.order')); ?></label>
                                    <input class="form-control" name="order" type="number" min="0" autocomplete="off" placeholder="<?php echo e(trans('home.order')); ?>" value="<?php echo e($slider->order); ?>">
                                </div>

                                <div class="form-group col-md-6">
                                    <label class=""><?php echo e(trans('home.text_en')); ?></label>
                                    <input class="form-control" name="text_en" type="text" placeholder="<?php echo e(trans('home.text_en')); ?>" value="<?php echo e($slider->text_en); ?>">
                                </div>
                                <div class="form-group col-md-6">
                                    <label class=""><?php echo e(trans('home.text_ar')); ?></label>
                                    <input class="form-control" name="text_ar" type="text" placeholder="<?php echo e(trans('home.text_ar')); ?>" value="<?php echo e($slider->text_ar); ?>">
                                </div>
                              <div class="form-group col-md-8">
                                    <label class=""><?php echo e(trans('home.link')); ?></label>
                                    <div class="input-group">
                                        <div class="input-group-prepend">
                                            <span class="input-group-text"><?php echo e(trans('home.link')); ?></span>
                                        </div>
                                        <input type="text" class="form-control" name="link" placeholder="<?php echo e(trans('home.link')); ?>"  value="<?php echo e($slider->link); ?>">
                                    </div>
                                </div>
                                

                                <div class="col-12">
                                    <div class="row align-items-center">
                                        <div class="form-group  col-md-10">
                                            <label><?php echo e(trans('home.image')); ?> (max 1mb, extension must .webp)</label>
                                            <div class="input-group mb-1">
                                                <div class="input-group-prepend">
                                                    <span class="input-group-text"> <?php echo e(trans('home.upload')); ?></span>
                                                </div>
                                                <div class="custom-file">
                                                    <input type="file" class="custom-file-input" name="image">
                                                    <label class="custom-file-label" for="inputGroupFile01"><?php echo e(trans('home.choose_image')); ?></label>
                                                </div>
                                            </div>
                                        </div>

                                        <div class="form-group  col-md-2">
                                            <img src="<?php echo e($slider->image_path); ?>" width="350" height="150">
                                        </div>
                                    </div>
                                </div>
                                <br>
                                <div class="form-group col-md-4">
                                    <label class="ckbox">
                                        <input name="status" value="1" <?php echo e(($slider->status == 1)? 'checked':''); ?> type="checkbox"><span class="tx-13"><?php echo e(trans('home.publish')); ?></span>
                                    </label>
                                </div>

                                <div class="form-group col-md-12">
                                    <button type="submit" class="btn btn-success"><i class="icon-note"></i> <?php echo e(trans('home.save')); ?> </button>
                                    <a href="<?php echo e(url('/admin/sliders')); ?>"><button type="button" class="btn btn-danger mr-1"><i class="icon-trash"></i> <?php echo e(trans('home.cancel')); ?></button></a>
                                </div>

                            </div>
                    </form>
                    </div>
                </div>
            </div>
        </div>
        <!-- End Row -->
    </div>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/webtest3/public_html/naguib-selim/resources/views/admin/sliders/home-sliders/editSlider.blade.php ENDPATH**/ ?>