<?php

use App\Http\Controllers\website\CheckoutController;
use App\Http\Controllers\website\HomeController;
use App\Http\Controllers\website\PlaceOrderController;
use App\Http\Controllers\website\ProductController;
use App\Http\Controllers\website\SampleRequestController;
use App\Http\Controllers\website\SearchController;
use App\Http\Controllers\website\WebsiteController;
use App\Http\Controllers\website\WishListController;
use Illuminate\Support\Facades\Route;

Route::group(['controller' => WebsiteController::class, 'as' => 'website.'], function () {
    Route::get('/', HomeController::class)->name('home');
    Route::get('categories/{category?}', 'getCategories')->name('categories');
    Route::get('category/{category}/products', 'getCategoryProducts')->name('category.products');
    Route::get('page/{link}', 'getPage')->name('page.details');
    Route::get('about-us', 'getAboutUs')->name('about');
    Route::get('contact-us', 'contactUs')->name('contact');
    Route::post('save/contact-us', 'saveContactUs')->name('saveContact')->middleware('throttle:2');
    Route::get('commercial-request', 'commercialRequest')->name('commercial.request');
    Route::post('save/commercial-request', 'saveCommercialRequest')->name('saveCommercialRequest')->middleware('throttle:2');
    Route::get('inspection-request', 'inspectionRequest')->name('inspection.request');
    Route::post('save/inspection-request', 'saveInspectionRequest')->name('saveInspectionRequest')->middleware('throttle:2');
    Route::get('branches', 'getBranches')->name('branches');
    Route::post('branches-filter', 'getBranchesFilter')->name('branches.filter');
    Route::get('moodboards', 'getMoodboards')->name('moodboards');
    Route::post('subscribe', 'subscribe')->name('subscribe')->middleware('throttle:2');
    Route::get('open-quick-view-modal', 'getQuickViewModal');
    Route::get('/search', [SearchController::class, 'search'])->name('search');
    Route::get('blogs', 'getBlogs')->name('blogs');
    Route::get('blog/{blog}', 'getBlogDetails')->name('blog.details');
});

Route::group(['controller' => WishListController::class], function () {

    Route::post('add-to-wishlist', 'addToWishList')->name('add.to.wishlist');
    Route::post('remove-wishlist-item', 'removeWishListItem')->name('remove.wishlist.item');
    Route::get('wishlist', 'viewWishlist')->name('wishlist');

});

Route::group(['controller' => CheckoutController::class], function () {

    Route::get('checkouts', 'getCheckout')->name('checkout');
    Route::get('get-country/{countryId}/governorates',  'getGovernoratesByCountry');
    Route::post('/get-shipping-fees',  'getShippingFees');
    Route::post('apply-coupon', 'applyCoupon');
});


Route::post('place-order', PlaceOrderController::class)->name('place.order');

Route::group(['controller' => ProductController::class], function () {
    Route::get('products', 'getProducts')->name('products');
    Route::get('product/{product}', 'getProductDetails')->name('product.details');
    Route::get('get-variants',  'getVariantData')->name('variants.get');
});


Route::group(['prefix' => 'sample-request', 'controller' => SampleRequestController::class, 'as' => 'sample.request.'], function () {
    Route::post('add', 'addTOSampleRequest')->name('add');
    Route::get('checkout-sample-request', 'checkSampleRequest')->name('checkout');
    Route::post('place-sample-order', 'placeSampleOrder')->name('place.order');
    Route::delete('delete/{id}', 'deleteSampleRequest')->name('delete');
});
