<form class="show-form-address wd-form-address" id="formnewAddress" action="{{ route('addresses.store') }}" method="POST">
    @csrf
    <div class="title">{{__('home.Add a new address')}}</div>
    <div class="box-field grid-2-lg">
        <div class="tf-field style-1">
            <input class="tf-field-input tf-input" value="{{ auth()->user()->f_name }}" placeholder="{{ trans('home.f_name') }}" type="text" id="firstname" >
            <label class="tf-field-label fw-4 text_black-2" for="firstname">{{ trans('home.f_name') }}</label>
        </div>
        <div class="tf-field style-1">
        <input class="tf-field-input tf-input" value="{{ auth()->user()->l_name }}" placeholder="{{ trans('home.l_name') }}" type="text" id="lastname">
            <label class="tf-field-label fw-4 text_black-2" for="lastname">{{ trans('home.l_name') }}</label>
        </div>
    </div>

    <div class="box-field">
        <div class="tf-field style-1">
            <input class="tf-field-input tf-input" placeholder="{{ __('home.phone') }}" value="{{ old('phone') }}" type="text" id="phone" name="phone">
            <label class="tf-field-label fw-4 text_black-2" for="phone">{{ __('home.phone') }}</label>
        </div>
    </div>

    <div class="box-field">
        <label for="country" class="mb_10 fw-4 text-start d-block text_black-2 ">{{__('home.country') }}</label>
        <div class="select-custom">
            <select class="tf-select w-100 select2" id="country" name="country_id">
                @foreach ($countries as $country )
                <option value="{{ $country->id }}">{{$country->name}}
                </option>
                @endforeach

            </select>
        </div>
    </div>

    <div class="box-field">
        <label for="governorate" class="mb_10 fw-4 text-start d-block text_black-2 ">{{__('home.governorate') }}</label>
        <div class="select-custom">
            <select class="tf-select w-100 governorate select2"   value="{{ old('governorate_id') }}" name="governorate_id">
                <option value="">{{ __('home.select_governorate') }}</option>
                @foreach ($governorates as $governorate )
                <option value="{{ $governorate->id }}">{{$governorate->name}}
                </option>
                @endforeach

            </select>
        </div>
    </div>

    <div class="box-field">
        <div class="tf-field style-1">
            <input class="tf-field-input tf-input" placeholder="{{ __('home.city') }}" type="text" id="city" value="{{ old('city') }}" name="city">
            <label class="tf-field-label fw-4 text_black-2" for="city">{{ __('home.city') }}</label>
        </div>
    </div>

    <div class="box-field">
        <div class="tf-field style-1">
            <input class="tf-field-input tf-input" placeholder="{{ __('home.address') }}" type="text" id="address" value="{{ old('address') }}" name="address">
            <label class="tf-field-label fw-4 text_black-2" for="address">{{ __('home.address') }}</label>
        </div>
    </div>

    <div class="box-field text-start">
        <div class="box-checkbox fieldset-radio d-flex align-items-center gap-8">
            <input type="checkbox" id="check-new-address" name="is_primary" value="1" class="tf-check">
            <label for="check-new-address" class="text_black-2 fw-4">{{__('home.Set as default address') }}</label>
        </div>
    </div>
    <div class="d-flex align-items-center justify-content-center gap-20">
        <button type="submit" class="tf-btn btn-fill animate-hover-btn">{{__('home.Add a new address')}}</button>
        <span class="tf-btn btn-fill animate-hover-btn btn-hide-address">{{ __('home.cancel') }}</span>
    </div>
</form>