@extends('layouts.app')
@section('meta')
<title>{{trans('home.my_orders')}}</title>
@endsection
@section('content')
<!-- page-title -->
<div class="tf-page-title">
    <div class="container">
        <div class="heading text-center">{{trans('home.my_orders')}}</div>
    </div>
</div>
<!-- /page-title -->

<!-- page-cart -->
<section class="flat-spacing-11">
    <div class="container">
        <div class="row">
            <div class="col-lg-3">
                <div class="wrap-sidebar-account">
                    @include('website.userBoard.partials.account-nav')
                </div>
            </div>
            <div class="col-lg-9">
                <div class="my-account-content account-order">
                    <div class="wrap-account-order">
                        <table>
                            <thead>
                                <tr>
                                    <th class="fw-6">{{ __('home.order') }}</th>
                                    <th class="fw-6">{{ __('home.date') }}</th>
                                    <th class="fw-6">{{ __('home.order_status') }}</th>
                                    <th class="fw-6">{{ __('home.totalOrdersCost') }}</th>
                                    <th class="fw-6">{{ __('home.actions') }}</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach ($orders as $order)
                                <tr class="tf-order-item">
                                    <td>
                                        {{ $order->order_number }}
                                    </td>
                                    <td>
                                        {{ $order->formatted_created_at }}
                                    </td>
                                    <td>
                                        {{ $order->status_current }}
                                    </td>
                                    <td>
                                        {{ $order->total_price }} {{ $order->currency }}
                                    </td>
                                    <td>
                                        <a href="{{ LaravelLocalization::localizeUrl('account/orders/'.$order->id.'/details') }}" class="tf-btn btn-fill animate-hover-btn rounded-0 justify-content-center">
                                            <span>{{ __('home.view') }}</span>
                                        </a>
                                    </td>
                                </tr>
                                @endforeach


                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
<!-- page-cart -->
@endsection
