@extends('layouts.app')
@section('meta')
    <title{{ Auth::user()->name }}</title>
@endsection
@section('content')


<!-- page-title -->
<div class="tf-page-title">
    <div class="container">
        <div class="heading text-center">{{ __('home.order_details') }}</div>
    </div>
</div>
<!-- /page-title -->

<!-- page-cart -->
<section class="flat-spacing-11">
    <div class="container">
        <div class="row">
            <div class="col-lg-3">
                <div class="wrap-sidebar-account">
                    @include('website.userBoard.partials.account-nav')
                </div>
            </div>
            <div class="col-lg-9">
                <div class="wd-form-order">
                    <div class="order-head">
                        <div class="content">
                            <div class="badge">{{ $order->status_current }}</div>
                            <h6 class="mt-8 fw-5">{{ $order->order_number }}</h6>
                        </div>
                    </div>
                    <div class="tf-grid-layout md-col-2 gap-15">

                        <div class="item">
                            <div class="text-2 text_black-2">{{ __('home.date') }}</div>
                            <div class="text-2 mt_4 fw-6">{{ $order->formatted_created_at }}</div>
                        </div>
                        <div class="item">
                            <div class="text-2 text_black-2">{{ __('home.address') }}</div>
                            <div class="text-2 mt_4 fw-6">{{ $order->address->full_address }}</div>
                        </div>
                    </div>
                    <div class="widget-tabs style-has-border widget-order-tab">
                        <ul class="widget-menu-tab">


                            <li class="item-title active">
                                <span class="inner">{{ __('home.order_details') }}</span>
                            </li>

                            <li class="item-title">
                                <span class="inner">{{__('home.Items')}}</span>
                            </li>
                            <li class="item-title">
                                <span class="inner">{{__('home.order_tracking')}}</span>
                            </li>


                        </ul>
                        <div class="widget-content-tab ">
                            <div class="widget-content-inner active ">

                                <ul class="mt_20">
                                    <li>{{ __('home.order_number') }} : <span class="fw-7">{{ $order->order_number }}</span></li>
                                    <li>{{ __('home.date') }} : <span class="fw-7"> {{ $order->formatted_created_at }}</span></li>
                                    <li>{{ __('home.total_price') }} : <span class="fw-7">{{ $order->total_price }} {{ $order->currency }}</span></li>
                                    <li>{{ __('home.payment_method') }} : <span class="fw-7">{{ $order->paymentMethod->name }}</span></li>

                                </ul>
                            </div>



                            <div class="widget-content-inner">
                                @foreach ($order->products as $orderProduct )
                                <div class="order-head">
                                    <figure class="img-product">
                                        <img src="{{ $orderProduct->productStock->product->main_image_source }}" alt="{{ $orderProduct->productStock->product->alt_main_image }}">
                                    </figure>
                                    <div class="content">
                                        <div class="text-2 fw-6">{{ $orderProduct->productStock->product->name }}</div>
                                        <div class="mt_4"><span class="fw-6">{{ __('home.price') }} :</span>{{ $orderProduct->productStock->net_price }} {{ $orderProduct->productStock->currency }}</div>
                                    </div>
                                </div>
                                @endforeach
                                <ul>
                                    <li class="d-flex justify-content-between text-2">
                                        <span>{{ __('home.totalProducts') }}</span>
                                        <span class="fw-6">{{ $order->products_price }} {{ $order->currency }}</span>
                                    </li>
                                    @if($order->coupon)

                                    <li class="d-flex justify-content-between text-2 mt_4 pb_8 line">
                                        <span>{{ __('home.Total Discounts') }}</span>
                                        <span class="fw-6">{{ $order->coupon->coupon_amount }} {{ $order->currency }}</span>

                                    </li>
                                    @endif
                                    <li class="d-flex justify-content-between text-2 mt_8">
                                        <span>{{ __('home.total_price') }}</span>
                                        <span class="fw-6">{{ $order->total_price }} {{ $order->currency }}</span>
                                    </li>
                                </ul>
                            </div>
                            <div class="widget-content-inner">
                                <div class="widget-timeline">
                                    <ul class="timeline">
                                      
                                        @foreach ($order->orderStatus as  $status )
                                        <li>
                                            <div class="timeline-badge success"></div>
                                            <div class="timeline-box">
                                                <a class="timeline-panel" href="javascript:void(0);">
                                                    <div class="text-2 fw-6">{{ $status->status }}</div>
                                                    <span>{{date('Y/m/d', strtotime($status->created_at )) . ' '.date('h:i:s', strtotime($status->created_at))}}</span>
                                                </a>

                                            </div>
                                        </li>
                                        @endforeach
                                    </ul>
                                </div>
                            </div>



                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
<!-- page-cart -->


@endsection