@extends('layouts.app')

@section('content')
<!-- page-title -->
<div class="tf-page-title">
    <div class="container">
        <div class="heading text-center">{{ __('home.search_results') }}</div>
      
    </div>
</div>
<!-- /page-title -->
<!-- Section Product -->
<section class="flat-spacing-2">
    <div class="container">
        
            <div class="row">
              
                <div class="col-sm-12 col-md-12 col-lg-9">
                   
                    <div class="wrapper-control-shop">
                        <div class="meta-filter-shop"></div>
                        <div class="grid-layout wrapper-shop" data-grid="grid-3">
                            <!-- card product  -->
                            @forelse ($products as $key=>$product )
                            <div class="card-product" data-brand="brand-{{ $key }}"
                                data-price="{{ $product->productStock->price }}">
                                <div class="card-product-wrapper">
                                    <a href="{{ LaravelLocalization::LocalizeUrl('product/'.$product->link) }}"
                                        class="product-img">
                                        <img class="lazyload img-product" data-src="{{ $product->main_image_source }}"
                                            src="{{ $product->main_image_source }}"
                                            alt="{{ $product->alt_main_image }}">
                                        @if($product->second_image_source)
                                        <img class="lazyload img-hover" data-src="{{ $product->second_image_source }}"
                                            src="{{ $product->second_image_source }}"
                                            alt="{{ $product->second_image_source }}">
                                        @endif

                                    </a>

                                    @if(!$product->in_stock)
                                    <span class="alarm">{{ __('home.out of stock') }}</span>
                                    @endif

                                    <div class="list-product-btn column-left">
                                        <a href="javascript:void(0);"
                                            class="box-icon wishlist bg_white btn-icon-action">
                                            <span class="icon icon-heart add-wishList-item"
                                                data-product_id="{{ $product->id }}"></span>
                                            <span class="tooltip">{{__('home.add to wishlist')}}</span>
                                            <span class="icon icon-delete remove-wishList-item"
                                                data-product_id="{{ $product->id }}"></span>
                                        </a>

                                    </div>
                                    <div class="list-product-btn absolute-3">
                                        <a data-product_id="{{  $product->id }}" class="box-icon quick-view style-2">
                                            <span class="icon icon-view"></span>
                                            <span class="text">{{__('home.Quick View')}}</span>
                                        </a>

                                        <a data-product_id="{{ $product->id }}"
                                            class="box-icon btn-add-to-cart style-2 {{ $product->in_stock ? '' : 'disabled-link' }}"
                                            {{ $product->in_stock ? '' : 'aria-disabled=true' }}>
                                            <span class="icon icon-bag"></span>
                                            <span class="text"> {{ $product->in_stock ? __('home.Add to Cart') : 'Sold
                                                Out' }}</span>
                                        </a>

                                    </div>
                                    <!-- Discount percentage -->
                                    @if($product->discount)
                                    <div class="on-sale-wrap text-end">
                                        <div class="on-sale-item">{{ $product->productStock?->discount_percentage}}%
                                        </div>
                                    </div>
                                    @endif
                                </div>

                                <div class="card-product-info">
                                    <a href="{{ LaravelLocalization::LocalizeUrl('product/'.$product->link) }}"
                                        class="title link">{{ $product->name }}</a>
                                    <div class="product-prices d-flex justify-content-start">
                                        @if($product->discount)
                                        <!-- Original price -->
                                        <span class="compare-at-price"><del>{{ $product->productStock?->price }} {{
                                                $product->productStock?->currency }}</del></span>
                                        <!-- price after discount Original price -->
                                        <span class="price">{{ $product->productStock->net_price }} {{
                                            $product->currency}}</span>


                                        @else
                                        <span class="price">{{ $product->productStock->price }} {{
                                            $product->currency}}</span>
                                        @endif
                                    </div>


                                </div>
                            </div>
                            @empty
                            <div class="alert alert-primary" role="alert">
                                no products avalibale
                            </div>
                            @endforelse


                        </div>
                       
                    </div>
                </div>
            </div>
        
    </div>
</section>

<!-- /Section Product -->

@endsection

