@extends('layouts.app')
@section('meta')
<title>
    {{ __('home.sample_request_checkout') }}
</title>
@endsection
@section('content')
<!-- page-title -->
@include('website._breadcrumb', ['page_title' => __('home.sample_request_checkout')])
<!-- /page-title -->

<!-- page-cart -->
<section class="flat-spacing-11">
    <div class="container">
        <div class="tf-page-cart-wrap layout-2">
            <div class="tf-page-cart-item">
                <h5 class="fw-5 mb_20">{{ __('home.Billing details') }}</h5>
                <form action="{{ route('sample.request.place.order') }}" method="POST" class="form-checkout">
                    @csrf
                    <div class="box grid-2">
                        <fieldset class="fieldset">
                            <label for="first-name">{{ __('home.f_name') }}</label>
                            <input type="text" id="first-name" placeholder="{{ __('home.f_name') }}" value="{{ auth()->user()->f_name ?? old('f_name') }}" name='f_name' required>
                        </fieldset>
                        <fieldset class="fieldset">
                            <label for="last-name">{{ __('home.l_name') }}</label>
                            <input type="text" id="last-name" placeholder="{{ __('home.l_name') }}" value="{{ auth()->user()->l_name ?? old('l_name') }}" name='l_name' required>
                        </fieldset>
                    </div>

                    <div class="box grid-2">
                        <fieldset class="box fieldset">
                            <label for="phone">{{ __('home.Phone Number') }}</label>
                            <input type="number" id="phone" placeholder="{{ __('Enter phone number') }}" name="phone" value="{{ old('phone') }}" required>
                        </fieldset>
                        <fieldset class="box fieldset">
                            <label for="email">{{ __('home.Email') }}</label>
                            <input type="email" id="email" placeholder="{{ __('Enter email') }}" name="email" value="{{ old('email') }}">
                        </fieldset>
                    </div>

                    <fieldset class="box fieldset">
                        <label for="country">{{ __('home.country') }}</label>
                        <div class="select-custom">
                            <select class="tf-select w-100" id="country" name="country_id" required data-default="">
                                <option value="null">{{ __('home.select_country') }}</option>
                                @foreach ($countries as $country)
                                <option value="{{ $country->id }}" selected>{{ $country->name }}</option>
                                @endforeach
                            </select>
                        </div>
                    </fieldset>

                    <div class="box grid-2">
                        <fieldset>
                            <label for="governorates">{{ __('home.governorates') }}</label>
                            <div class="select-custom">
                                <select class="tf-select w-100 governorate" id="governorates" name="governorate_id" required data-default="">
                                    <option value="null">{{ __('home.select_governorate') }}</option>
                                    @foreach ($governorates as $governorate)
                                    <option value="{{ $governorate->id }}">{{ $governorate->name }}</option>
                                    @endforeach
                                </select>
                        </fieldset>

                        <fieldset class="box fieldset">
                            <label for="city">{{ __('home.Town/City') }}</label>
                            <input type="text" id="city" placeholder="{{ __('home.Town/City') }}" name="city" value="{{ old('city') }}" required>
                        </fieldset>
                    </div>



                    <fieldset class="box fieldset">
                        <label for="address">{{ __('home.Address') }}</label>
                        <input type="text" id="address" placeholder="{{ __('home.Address') }}" name="address" value="{{ old('address') }}" required>
                    </fieldset>

                    <fieldset class="box fieldset">
                        <label for="note">{{ __('home.Order notes (optional)') }}</label>
                        <textarea name="note" id="note">{{ old('note') }}</textarea>
                    </fieldset>

               
            </div>
            <div class="tf-page-cart-footer">
                <div class="tf-cart-footer-inner">
                    <h5 class="fw-5 mb_20">{{ __('home.sample_request_items') }}</h5>
                    <div class="tf-page-cart-checkout widget-wrap-checkout">
                        <ul class="wrap-checkout-product">
                            @foreach($sampleRequests as $sampleRequest)
                            <li class="checkout-product-item">
                                <figure class="img-product">
                                    @if($sampleRequest->product_variant_id)
                                    <img src="{{$sampleRequest->variant->first_image }}" alt="{{ $sampleRequest->product->name }}">
                                    @else

                                    <img src="{{ $sampleRequest->product->main_image_path }}" alt="{{ $sampleRequest->product->name }}">
                                    @endif
                                   
                                </figure>
                                <div class="content">
                                    <div class="info">
                                    <p class="name">{{ $sampleRequest->product->name }}</p>
                                    @if ($sampleRequest->variant)

                                        @foreach ($sampleRequest->variant->values as $value)
                                            <p><strong>{{ $value->value->attribute->name }}</strong>: {{ $value->value->value }}</p>
                                        @endforeach
                                    @endif
                                    </div>
                               
                                </div>
                            </li>
                            @endforeach
                        </ul>
                    
                        <div class="d-flex justify-content-between line pb_20">
                            <h6 class="fw-5">{{ __('home.shipping') }}</h6>
                           
                            <h6 class="simple-request-shipping-fees fw-5"> {{ config('app.currency') }} {{ config('site_standard_shipping_fees') }}</h6>
                            

                        </div>

                        <div class="wd-check-payment">
                            @foreach ($payment_methods as $paymentMethod)
                            <div class="fieldset-radio mb_20">
                                <input type="radio" name="payment_method_id" value="{{ $paymentMethod->id }}" id="payment_method_{{ $paymentMethod->id }}" class="tf-check" checked>
                                <label for="payment_method_{{ $paymentMethod->id }}">{{ $paymentMethod->name }}</label>

                            </div>
                            @endforeach
                           
                        </div>
                        <button type="submit" class="tf-btn radius-3 btn-fill btn-icon animate-hover-btn justify-content-center">{{ __('home.place_order') }}</button>
                    </div>
                </div>
            </div>

        </form>
        </div>
    </div>
</section>
<!-- page-cart -->

@endsection
@section('script')
@if($errors->any())
<script>
    toastr.options = {
        "closeButton": true
        , "progressBar": true
        , "positionClass": "toast-top-right"
    };
    @foreach($errors -> all() as $error)
    toastr.error("{{$error}}");
    @endforeach

</script>

@endif
@endsection