<div class="tf-mini-cart-main">
    <div class="tf-mini-cart-sroll">
        <div class="tf-mini-cart-items">
            @forelse ($cart->items as $cardItem)
            <div class="tf-mini-cart-item">
                <div class="tf-mini-cart-image">
                    <a href="{{ route('product.details',$cardItem->product->link)  }}">
                        <img src="{{ $cardItem->variant?->first_image ?? $cardItem->product->main_image_path }}" alt="{{ $cardItem->product->name }}">
                    </a>
                </div>
                <div class="tf-mini-cart-info">
                    <a class="title link" href="{{ $cardItem->product->link }}">
                        {{ $cardItem->product->name }}
                    </a>
                    {{-- Variant Attributes --}}
                    @if ($cardItem->variant)
                    @foreach ($cardItem->variant->values as $value)
                    <p><strong>{{ $value->value->attribute->name }}</strong>: {{ $value->value->value }}</p>
                    @endforeach
                    @endif

                    {{-- Pricing --}}
                    @if($cardItem->product->isOnSale($cardItem->variant?->id))
                    <div class="sale-price">
                        <strong>Now</strong>: {{ config('app.currency') }} {{ $cardItem->product->getEffectivePrice($cardItem->variant?->id) }}
                    </div>
                    <div class="original-price">
                        <strong>Before sale price</strong>:
                        <del>{{ config('app.currency') }} {{ $cardItem->product->getOriginalPrice($cardItem->variant?->id) }}</del>
                    </div>
                    <div class="save-discount">
                        <strong>Save</strong>: {{ config('app.currency') }} {{ $cardItem->product->getDiscountAmount($cardItem->variant?->id) }}
                    </div>
                    @else
                    <strong class="original-price">
                        {{ config('app.currency') }} {{ $cardItem->product->getOriginalPrice($cardItem->variant?->id) }}
                    </strong>
                    @endif

                    {{-- quantity --}}
                    <div class="tf-mini-cart-btns">
                        <div class="wg-quantity small">
                            <span class="btn-quantity minus-btn">-</span>
                            <input type="text" name="number" value="{{ $cardItem->quantity }}">
                            <span class="btn-quantity plus-btn">+</span>
                        </div>
                        <div class="tf-mini-cart-remove" data-cart_item_id="{{ $cardItem->id }}">Remove</div>
                    </div>
                </div>
            </div>
            @empty
            @include('website.layouts.modals.partials._empty_cart')
            @endforelse
        </div>

        {{-- Recommendations --}}
        @include('website.layouts.modals.partials._cart_recommendation_products', ['relatedProducts' => $related_cart_products])
        {{-- End Recommendations --}}

          {{-- Cart Bottom --}}
        @if( $cart->total_price > 0)
            <div class="tf-mini-cart-bottom">
                <div class="tf-mini-cart-bottom-wrap">
                    <div class="tf-cart-totals-discounts">
                        <div class="tf-cart-total">Subtotal</div>
                        <div class="tf-totals-total-value fw-6">
                            {{ config('app.currency') . ' ' . $cart->total_price }}
                        </div>
                    </div>
                    <div class="tf-cart-tax">
                        {{ __('home.Taxes and shipping calculated at checkout') }}
                    </div>
                    <div class="tf-mini-cart-line"></div>
    
                    <div class="tf-mini-cart-view-checkout">
                        <a href="{{ route('shopping-cart') }}" class="tf-btn btn-outline radius-3 link w-100 justify-content-center">
                            {{ __('home.View Cart') }}
                        </a>
                        <a href="{{ route('checkout') }}" class="tf-btn btn-fill animate-hover-btn radius-3 w-100 justify-content-center">
                            <span>{{ __('home.checkout') }}</span>
                        </a>
                    </div>
                </div>
            </div>
        @endif
    </div>
  
</div>
