<div class="card-product bg_white radius-0"  data-currency="{{ config('app.currency') }}">
    <div class="card-product-wrapper">
        <a href="{{ route('product.details', $product->link) }}" class="product-img">
            <img class="lazyload img-product" data-src="{{ $product->defaultVariant->first_image }}" src="{{ $product->defaultVariant->first_image }}" alt="{{ $product->name }} - {{ $product->defaultVariant->color }}">
            <img class="img-hover ls-is-cached lazyloaded" data-src="{{ $product->defaultVariant->second_image }}" src="{{ $product->defaultVariant->second_image }}" alt="{{ $product->name }} - {{ $product->defaultVariant->color }}">

        </a>
        @if($product->isInStock($product->defaultVariant->id) == false)
            <span class="alarm">{{ __('home.out of stock') }}</span>
        @endif
    </div>

    <div class="card-product-info has-padding">
        <a href="{{ route('product.details', $product->link) }}" class="title link">
            {{ $product->name }}
        </a>


        @if($product->isOnSale(($product->defaultVariant->id)))
            <div class="sale-price">
                <strong>Now:</strong> {{ config('app.currency') }} {{ $product->getEffectivePrice($product->defaultVariant->id) }}
            </div>
            <div class="original-price">
                <strong>Before sale price:</strong>
                <del>{{ config('app.currency') }} {{ $product->getOriginalPrice($product->defaultVariant->id) }}</del>
            </div>
            <div class="save-discount">
                <strong>Save:</strong> {{ config('app.currency') }} {{ $product->getDiscountAmount($product->defaultVariant->id) }}
            </div>
        @else
            <span class="original-price">{{ config('app.currency') }} {{ $product->getOriginalPrice($product->defaultVariant->id) }}</span>
        @endif

        <ul class="list-color-product">

            @foreach ($product->available_colors as $colorGroup)

            <li class="list-color-item color-swatch {{ $loop->first ? 'active' : '' }}"
                data-currency="{{ config('app.currency') }}"
                data-color="{{ $colorGroup['color'] }}"
                data-is-on-sale="{{ $product->isOnSale($colorGroup['variant_id']) }}"
                data-original-price="{{ $product->getOriginalPrice($colorGroup['variant_id']) }}"
                data-effective-price="{{ $product->getEffectivePrice($colorGroup['variant_id']) }}"
                data-discount-amount="{{ $product->getDiscountAmount($colorGroup['variant_id']) }}"
                data-is-in-stock="{{ $product->isInStock($colorGroup['variant_id']) ? 'true' : 'false' }}"
            >
                <span class="tooltip">{{ $colorGroup['color'] }}</span>
                <span class="swatch-value" style="background-color:{{$colorGroup['color']  }}"></span>
                <img class="lazyload" data-src="{{ $colorGroup['image'] }}" src="{{ $colorGroup['image'] }}" alt="{{ $product->name }} - {{ $colorGroup['color'] }}">
            </li>
            @endforeach
        </ul>
    </div>
</div>
