@extends('layouts.app')
@section('meta')
@php echo $metatags @endphp

@php echo $schema @endphp
@endsection
@section('content')
<!-- page-title -->
@include('website._breadcrumb', ['page_title' => __('home.commercial_request')])
<!-- /page-title -->


<!-- form -->
<section class="flat-spacing-21">
    <div class="container">
        <div class="tf-grid-layout gap30 lg-col-2">
            <div class="tf-content-left">

                <figure class="br-lg">
                    @if(app()->getLocale() == 'ar')
                       <img src="{{asset('assets/front/images/commercial_request.jpg')}}" alt="commercials request image" width="610" height="500"/>
                    @else
                     <img src="{{asset('assets/front/images/commercial_request.jpg')}}" alt="commercials request image" width="610" height="500"/>
                    @endif
                 
                </figure>
            </div>
            <div class="tf-content-right">
                <div class="tf-page-cart-item">
                    
                    <form action="{{ route('website.saveCommercialRequest') }}" method="POST" class="form-checkout">
                        @csrf
                        <div  class="box fieldset">
                            <fieldset class="fieldset">
                                <label for="first-name">{{ __('home.name') }}</label>
                                <input type="text" id="first-name" placeholder="{{ __('home.name') }}" value="{{  old('name') }}" name='name' required>
                            </fieldset>
                            
                        </div>
    
                        <div class="box grid-2">
                            <fieldset class="box fieldset">
                                <label for="phone">{{ __('home.Phone Number') }}</label>
                                <input type="number" id="phone" placeholder="{{ __('Enter phone number') }}" name="phone" value="{{ old('phone') }}" required>
                            </fieldset>
                            <fieldset class="box fieldset">
                                <label for="email">{{ __('home.Email') }}</label>
                                <input type="email" id="email" placeholder="{{ __('Enter email') }}" name="email" value="{{ old('email') }}">
                            </fieldset>
                        </div>
    
                        <fieldset class="box fieldset">
                            <label for="country">{{ __('home.country') }}</label>
                            <div class="select-custom">
                                <select class="tf-select w-100" id="country" name="country_id" required data-default="">
                                    <option value="null">{{ __('home.select_country') }}</option>
                                    @foreach ($countries as $country)
                                    <option value="{{ $country->id }}" selected>{{ $country->name }}</option>
                                    @endforeach
                                </select>
                            </div>
                        </fieldset>
    
                        <div class="box grid-2">
                            <fieldset>
                                <label for="governorates">{{ __('home.governorates') }}</label>
                                <div class="select-custom">
                                    <select class="tf-select w-100 governorate" id="governorates" name="governorate_id" required data-default="">
                                        <option value="null">{{ __('home.select_governorate') }}</option>
                                        @foreach ($governorates as $governorate)
                                        <option value="{{ $governorate->id }}">{{ $governorate->name }}</option>
                                        @endforeach
                                    </select>
                            </fieldset>
    
                            <fieldset class="box fieldset">
                                <label for="city">{{ __('home.Town/City') }}</label>
                                <input type="text" id="city" placeholder="{{ __('home.Town/City') }}" name="city" value="{{ old('city') }}" required>
                            </fieldset>
                        </div>
    
    
    
                        <fieldset class="box fieldset">
                            <label for="address">{{ __('home.Address') }}</label>
                            <input type="text" id="address" placeholder="{{ __('home.Address') }}" name="address" value="{{ old('address') }}" required>
                        </fieldset>

                        <div class="box grid-3">
                            <fieldset>
                                <label for="type_of_activity">{{ __('home.Type of activity') }}</label>
                                <div class="select-custom">
                                    <select class="tf-select w-100" name="type_of_activity" required>
                                        <option value="">{{trans('home.Type of activity')}}</option>
                                        <option value="{{(app()->getLocale()=='en')? "Fair":"معرض"}}">{{(app()->getLocale()=='en')? "Fair":'معرض'}}</option>
                                        <option value="{{(app()->getLocale()=='en')? "Factory":"مصنع"}}">{{(app()->getLocale()=='en')? "Factory":'مصنع'}}</option>
                                        <option value="{{(app()->getLocale()=='en')? "workshop":"ورشة"}}">{{(app()->getLocale()=='en')? "workshop":'ورشة'}}</option>
                                        <option value="{{(app()->getLocale()=='en')? "Upholsterer":"منجد"}}">{{(app()->getLocale()=='en')? "Upholsterer":'منجد'}}</option>
                                        <option value="{{(app()->getLocale()=='en')? "Engineer":"مهندس"}}">{{(app()->getLocale()=='en')? "Engineer":'مهندس'}}</option>
                                        <option value="{{(app()->getLocale()=='en')? "Finishing company":"شركة تشطيبات"}}">{{(app()->getLocale()=='en')? " Finishing company":'شركة تشطيبات'}}</option>
                                        <option value="{{(app()->getLocale()=='en')? "Company":"شركة"}}">{{(app()->getLocale()=='en')? "Company":'شركة'}}</option>
                                        <option value="{{(app()->getLocale()=='en')? "Hotel":"فندق"}}">{{(app()->getLocale()=='en')? "Hotel":' فندق'}}</option>
                                        <option value="{{(app()->getLocale()=='en')? "project resource":"مورد مشروعات"}}">{{(app()->getLocale()=='en')? " Project resource":'مورد مشروعات'}}</option>
                                        <option value="{{(app()->getLocale()=='en')? "purchasing Manager":"مدير مشتريات"}}">{{(app()->getLocale()=='en')? " Purchasing Manager":'مدير مشتريات'}}</option>
                                        <option value="{{(app()->getLocale()=='en')? "Real Estate Company":"شركة عقارات"}}">{{(app()->getLocale()=='en')? " Real Estate Company":'شركة عقارات'}}</option>
                                       
                                </select>
                            </fieldset>
    
                            <fieldset>
                                <label for="category">{{ __('home.product_type') }}</label>
                                <div class="select-custom">
                                    <select class="tf-select w-100 category" name="category" required>
                                        <option value="">{{trans('home.Product type')}}</option>
                                             <option value="{{(app()->getLocale()=='en')? "velvet": "قطيفة"}}">{{(app()->getLocale()=='en')? "velvet": "قطيفة"}}</option>
                                             <option value="{{(app()->getLocale()=='en')? "Linen": "كتان"}}">{{(app()->getLocale()=='en')? "Linen": "كتان"}}</option>
                                             <option value="{{(app()->getLocale()=='en')? "Booklet": "كتان"}}">{{(app()->getLocale()=='en')? "Booklet": "بوكلت"}}</option>
                                             <option value="{{(app()->getLocale()=='en')? "Faux leather": "جلد مقلوب"}}">{{(app()->getLocale()=='en')? "Faux leather": "جلد مقلوب"}}</option>
                                             <option value="{{(app()->getLocale()=='en')? "leather": "جلد"}}">{{(app()->getLocale()=='en')? "leather": "جلد"}}</option>
                                             <option value="{{(app()->getLocale()=='en')? "Voile": "ستائر خفيف"}}">{{(app()->getLocale()=='en')? "Voile": "ستائر خفيف"}}</option>
                                      
                                     </select>
                            </fieldset>
                            
                            <fieldset>
                                <label for="price_category">{{ __('home.Price category') }}</label>
                                <div class="select-custom">
                                    <select class="tf-select w-100 " name="price_category" required>
                                        <option value="">{{trans('home.Price category')}}</option>
                                        <option value="80:150">80:150</option>
                                        <option value="150:200">150:200</option>
                                        <option value="200:300">200:300</option>
                                        <option value="300:Above">{{app()->getLocale() == 'en' ? "300:Above" : "300:الاعلي"}}</option>
                                  
                                    </select>
                                </div>
                            </fieldset>
                        </div>
    
                        <fieldset class="box fieldset">
                            <label for="note">{{ __('home.Order notes (optional)') }}</label>
                            <textarea name="note" id="note">{{ old('note') }}</textarea>
                        </fieldset>
    
                   
                        <div class="box">
                         
                            <button type="submit" class="tf-btn radius-3 btn-fill btn-icon animate-hover-btn justify-content-center">{{ __('home.send_request') }}</button>

                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</section>
<!-- /form -->




@endsection
