@extends('layouts.admin')
<title>{{trans('home.simple_request_orders')}}</title>
@section('content')

<div class="container-fluid">
    <!-- Page Header -->
    <div class="page-header">

        <div>
            <h2 class="main-content-title tx-24 mg-b-5">{{trans('home.simple_request_orders')}}</h2>
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="{{url('/admin')}}">{{trans('home.admin')}}</a></li>
                <li class="breadcrumb-item active" aria-current="page">{{trans('home.simple_request_orders')}}</li>
            </ol>
        </div>

        <div class="btn btn-list">


            {{-- <a id="btn_delete" ><button class="btn ripple btn-danger"><i class="fas fa-trash"></i> {{trans('home.delete')}}</button></a> --}}

            <a href="#" class="btn ripple btn-secondary navresponsive-toggler mb-0" data-toggle="collapse" data-target="#navbarSupportedContent" aria-controls="navbarSupportedContent" aria-expanded="false" aria-label="Toggle navigation">
                <i class="fe fe-filter mr-1"></i> {{trans('home.filter')}} <i class="fas fa-caret-down ml-1"></i>
            </a>

        </div>
    </div>
    <!-- End Page Header -->

    <form action="{{url()->current()}}" method="get">
        <div class="responsive-background">
            <div class="collapse navbar-collapse" id="navbarSupportedContent">
                <div class="advanced-search">
                    <div class="row align-items-center">

                        <div class="form-group col-md-4">
                            <label for="code">{{trans('home.from')}}</label>
                            <div class="input-group">
                                <input type='date' class="form-control" name="from" placeholder="{{trans('home.to')}}" />

                            </div>
                        </div>

                        <div class="form-group col-md-4">
                            <label for="code">{{trans('home.to')}}</label>
                            <div class="input-group">
                                <input type='date' class="form-control dateFrom" name="to" placeholder="{{trans('home.to')}}" />
                                <div class="input-group-append">
                                    <span class="input-group-text">
                                        <i class="fas fa-calendar"></i>
                                    </span>
                                </div>
                            </div>
                        </div>

                        <div class="form-group col-md-4">
                            <label for="helperText">{{trans('home.order_status')}}</label>
                            <select class="form-control select2" name="order_status" id="order-status">
                                <option></option>
                                <option value="pending">{{trans('home.pending')}}</option>
                                <option value="accept">{{trans('home.accept')}}</option>
                                <option value="process">{{trans('home.process')}}</option>
                                <option value="shipping">{{trans('home.shipping')}}</option>
                                <option value="delivered">{{trans('home.delivered')}}</option>
                                <option value="canceled">{{trans('home.canceled')}}</option>
                            </select>
                        </div>
                    </div>
                    <hr>
                    <div class="text-right">
                        <button type="submit" class="btn btn-primary ">{{trans('home.applay')}}</button>
                        <a href="{{url()->current()}}" class="btn btn-secondary">{{trans('home.reset')}}</a>
                    </div>
                </div>
            </div>
        </div>
    </form>
    <!-- Row-->
    <div class="row">
        <div class="col-sm-12 col-xl-12 col-lg-12">

            <div class="card custom-card overflow-hidden">
                <div class="card-body">
                    <div class="filter-result">
                        <div>
                            <h6 class="card-title mb-1">{{trans('home.orders')}}</h6>
                            <p class="text-muted card-sub-title">{{trans('home.table_contain_all_data_shortly_you_can_view_more_details')}}</p>
                        </div>
                        <div class="table-responsive">
                            <table class="table" id="exportexample" data-order='[[ 1, "desc" ]]'>
                                <thead>
                                    <tr>
                                        <th>#</th>
                                        <th>{{ __('home.id') }}</th>
                                        <th>{{trans('home.order_number')}}</th>
                                        <th>{{trans('home.order_date')}}</th>
                                        <th>{{trans('home.order_user')}}</th>
                                        {{-- <th>{{ __('home.customer_status') }}</th> --}}
                                        <th>{{ __('home.Email Address') }}</th>
                                        <th>{{trans('home.order_phone_numbers')}}</th>
                                        <th>{{ __('home.total') }}</th>
                                        <th>{{ __('home.products') }}</th>
                                        <th>{{trans('home.order_address')}}</th>
                                        <th>{{trans('home.order_status')}}</th>
                                        <th>{{ trans(__('home.shipping_status')) }}</th>
                                        <th>{{trans('home.payment_status')}}</th>
                                        <th>{{trans('home.payment_method')}}</th>
                                        @can('delete_order')
                                        <th>Delete</th>
                                        @endcan
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($orders as $key=>$order)

                                    <tr>
                                        <td><a href="{{ route('simple_request_orders.edit', $order->id) }}">{{ $key+1}}</a></td>
                                        <td><a href="{{ route('simple_request_orders.edit', $order->id) }}">{{$order->id}}</a></td>
                                        <td><a href="{{ route('simple_request_orders.edit', $order->id) }}">{{$order->order_number}}</a></td>
                                        <td>{{date('Y-m-d', strtotime($order->created_at ))}}</td>
                                        <td><a href="{{ route('simple_request_orders.edit', $order->id) }}">{{$order->user->f_name.' '.$order->user->l_name}}</a></td>
                                        {{-- <td>
                                            @if($order->is_first_order)
                                            <span class="badge badge-success">{{ __('home.first_time') }}</span>
                                            @else
                                            <span class="badge badge-warning">{{ __('home.2repeat_customer') }}</span>
                                            @endif
                                            <br> <br>
                                            <small>{{ __('home.total_orders') }}: {{ $order->total_orders_by_phone }}</small>
                                        </td> --}}
                                        <td><a href="{{ route('simple_request_orders.edit', $order->id) }}">{{$order->user->email}}</a></td>
                                        <td><a href="{{ route('simple_request_orders.edit', $order->id) }}">{{$order->address?->phone ?? trans('home.unknown_phone') }} </a></td>
                                        <td><a href="{{ route('simple_request_orders.edit', $order->id) }}">{{$order->total_amount .' ' . config('app.currency') }} </a></td>
                                        <!-- NEW PRODUCTS COLUMN -->
                                        <td>
                                            @if($order->items && $order->items->count() > 0)
                                            @foreach($order->items as $item)
                                            <div>
                                                {{ $item->product->name  }}
                                                @if ($item->product->variant)

                                                @foreach ($item->product->variant->values as $value)
                                                    <p><strong>{{ $value->value->attribute->name }}</strong>: {{ $value->value->value }}</p>
                                                @endforeach
                                            @endif
                                            </div>
                                            @endforeach
                                            @else
                                            <span>{{ __('home.no_products') }}</span>
                                            @endif
                                        </td>

                                        <td><a href="{{ route('simple_request_orders.edit', $order->id) }}">{{$order->address->full_address ?? trans('home.unknown_address')}}</a></td>

                                        <td>
                                            @if($order->status_name == 'Pending')
                                            <span class="badge badge-primary">{{trans('home.Pending')}}</span>
                                            @elseif($order->status_name == 'Processing')
                                            <span class="badge badge-secondary">{{trans('home.Processing')}}</span>
                                            @elseif($order->status_name == 'Confirmed')
                                            <span class="badge badge-info">{{trans('home.Confirmed')}}</span>
                                            @elseif($order->status_name == 'Shipped')
                                            <span class="badge badge-default">{{trans('home.Shipped')}}</span>
                                            @elseif($order->status_name == 'Out for Delivery')
                                            <span class="badge badge-success">{{trans('home.Out for Delivery')}}</span>
                                            @elseif($order->status_name == 'Delivered')
                                            <span class="badge badge-success">{{trans('home.Delivered')}}</span>
                                            @elseif($order->status_name == 'Cancelled')
                                            <span class="badge badge-danger">{{trans('home.Cancelled')}}</span>
                                            @elseif($order->status_name == 'Refunded')
                                            <span class="badge badge-danger">{{trans('home.Refunded')}}</span>
                                            @elseif ($order->status_name == 'Failed')
                                            <span class="badge badge-danger">{{trans('home.Failed')}}</span>
                                            @elseif ($order->status_name == 'On Hold')
                                            <span class="badge badge-danger">{{trans('home.On Hold')}}</span>
                                            @endif

                                        </td>

                                        <td>
                                            @if($order->latestShipment)
                                            <span class="badge badge-info">{{ $order->latestShipment->shipmentStatus->name }}</span>
                                            @else
                                            <span class="badge badge-warning">{{ __('home.No Shipment') }}</span>
                                            @endif
                                        </td>

                                        @if($order->payment?->status == 'paid')
                                        <td><a href="{{ route('simple_request_orders.edit', $order->id) }}">{{ __('home.paid')}} </a></td>
                                        <td><a href="{{ route('simple_request_orders.edit', $order->id) }}">{{ $order->payment->paymentMethod?->name }}</a></td>
                                        @else
                                        <td><a href="{{ route('simple_request_orders.edit', $order->id) }}">{{ __('home.unpaid')}} </a></td>
                                        <td><a href="{{ route('simple_request_orders.edit', $order->id) }}">{{ $order->payment?->paymentMethod?->name }}</a></td>
                                        @endif

                                        
                                        <td>
                                            <form action="{{ route('simple_request_orders.destroy',$order->id) }}" method="POST">
                                                @csrf
                                                @method('DELETE')
                                                <button type="submit" class="btn btn-danger btn-sm delete" data-toggle="modal" data-target="#deleteModal"><i class="fas fa-trash"></i></button>
                                            </form>
                                        </td>
                                      
                                    </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                    </div>

                </div>
            </div>
        </div>
    </div>
    <!-- End Row -->
</div>
@endsection


@section('script')
<script>
    $(document).on({
        ajaxStart: function() {
            $('#loader').show();
        }
        , ajaxStop: function() {
            $('#loader').hide();
        }
    });

    $('.order-filter').on('click', function() {
        var dateFrom = $('.dateFrom').val();
        var dateTo = $('.dateTo').val();
        var status = $('#order-status option:selected').val();

        if (dateFrom && dateTo) {
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });

            $.ajax({
                url: " {{url('admin/orders/filter')}}"
                , method: 'POST'
                , data: {
                    dateFrom: dateFrom
                    , dateTo: dateTo
                    , status: status
                }
                , success: function(html) {
                    $('.filter-result').html(html.html);
                }
            });
        } else {
            alert("{{trans('home.Please Select Date From And Date To')}}");
        }
    });

    $('.reset').click(function() {
        $('input[type="text"]').val('');
        $('select').val('').trigger('change');;
    });

    $("#datepicker1").datepicker({
        changeMonth: true
        , changeYear: true
        , dateFormat: 'yy-mm-dd'
    });

    $("#datepicker2").datepicker({
        changeMonth: true
        , changeYear: true
        , dateFormat: 'yy-mm-dd'
    });

</script>
@endsection
