@extends('layouts.admin')
@section('meta')
<title>{{ $discount->name }}</title>
@endsection
@section('content')
<div class="spainer"></div>
<div class="container-fluid">
    <!-- Page Header -->
    <div class="page-header">
        <div>
            <h2 class="main-content-title tx-24 mg-b-5">{{ trans('home.discounts') }}</h2>
            <ol class="breadcrumb">
                <li class="breadcrumb-item">
                    <a href="{{ url('/admin') }}"> {{ trans('home.admin') }}</a>
                </li>
                <li class="breadcrumb-item">
                    <a href="{{ route('products.discounts.index',$product->id) }}">{{ trans('home.discounts') }} </a>
                </li>

                <li class="breadcrumb-item active" aria-current="page">{{ $discount->name }}</li>
            </ol>
        </div>
    </div>
    <div class="row">
        <div class="col-sm-12 col-xl-12 col-lg-12">
            <div class="card custom-card overflow-hidden">
                <div class="card-body">
                    <form action="{{ route('products.discounts.update', [$product->id, $discount->id]) }}" method="post">
                        @method('PUT')
                        @csrf

                        <div class="row">
                            <div class="form-group col-md-3">
                                <label>{{ trans('home.name') }}</label>
                                <input class="form-control" name="name" type="text" placeholder="Discount name like 'Summer Sale', 'Black Friday'" value="{{ old('name', $discount->name) }}">
                            </div>

                            <div class="form-group col-md-3">
                                <label>{{ trans('home.type') }}</label>
                                <select class="form-control" name="type">
                                    @foreach (App\Models\ProductDiscount::TYPES as $type)
                                    <option value="{{ $type }}" @selected(old('type', $discount->type) == $type)>
                                        {{ ucfirst($type) }}
                                    </option>
                                    @endforeach
                                </select>
                            </div>

                            <div class="form-group col-md-3">
                                <label>{{ trans('home.value') }}</label>
                                <input class="form-control" name="value" type="number" placeholder="{{ trans('home.value') }}" value="{{ old('value', $discount->value) }}">
                            </div>

                            <div class="form-group col-md-3">
                                <label>{{ trans('home.apply_to') }}</label>
                                <select name="apply_to" class="form-control" id="apply_to_select">
                                    <option value="product" @selected(old('apply_to', $discount->apply_to) == 'product')>{{ __('home.product') }}</option>
                                    @if($product->has_variants)
                                    <option value="variant" @selected(old('apply_to', $discount->apply_to) == 'variant')>{{ __('home.variant') }}</option>
                                    @endif
                                </select>
                            </div>
                        </div>
                        <div class="row">
                            <div class="form-group col-md-3" id="variant_ids_wrapper" style="display: {{ $discount->apply_to == 'variant' ? 'block' : 'none' }};">
                                <label>{{ __('home.select_variants') }}</label>
                                <select name="variant_id" class="form-control">
                                    <option value="">Select Variant</option>
                                    @foreach($product->variants as $variant)
                                    <option value="{{ $variant->id }}" @selected(old('variant_id', $discount->variant_id) == $variant->id)>
                                        @foreach ($variant->values as $variantValue)
                                        <span class="badge badge-primary">{{ $variantValue->value->value }}</span>
                                        @endforeach
                                    </option>

                                    @endforeach
                                </select>
                            </div>


                            <div class="form-group col-md-3">
                                <label>{{ trans('home.start_date') }}</label>
                                <input class="form-control" name="starts_at" type="date" value="{{ old('starts_at', $discount->starts_at ? \Carbon\Carbon::parse($discount->starts_at)->format('Y-m-d') : '') }}">
                            </div>

                            <div class="form-group col-md-3">
                                <label>{{ trans('home.end_date') }}</label>
                                <input class="form-control" name="expires_at" type="date" value="{{ old('expires_at', $discount->expires_at ? \Carbon\Carbon::parse($discount->expires_at)->format('Y-m-d') : '') }}">
                            </div>

                            <div class="form-group col-md-3">
                                <label>{{ trans('home.is_active') }}</label><br>
                                <input type="checkbox" id="switch1" switch="none" value="1" name="is_active" {{ old('is_active', $discount->is_active) ? 'checked' : '' }}>
                            </div>
                        </div>

                        <div class="row">
                            <div class="form-group col-md-12">
                                <button type="submit" class="btn btn-success"> {{ trans('home.save') }} </button>
                            </div>
                        </div>
                    </form>

                </div>
            </div>
        </div>
    </div>

    @endsection
