@extends('layouts.admin')
@section('meta')
    <title>{{trans('home.admin_panel')}}</title>
@endsection
@section('content')

<div class="container-fluid">

	<!-- Page Header -->
	<div class="page-header">
		<div>
			<h2 class="main-content-title tx-24 mg-b-5">{{trans('home.Welcome To Dashboard')}}</h2>
		</div>
	</div>
	<!-- End Page Header -->

	<!-- Row -->
	<div class="row row-sm">
		@foreach ($reports as $key => $value )
		<div class="col-sm-6 col-xl-2 col-lg-6">
			<div class="card custom-card">
				<div class="card-body dash1">
					<div class="d-flex">
						<p class="mb-1 tx-inverse">{{$key}}</p>
						{{-- <div class="ml-auto">
							<i class="fas fa-chart-line fs-20 text-primary"></i>
						</div> --}}
					</div>
					<div>
						<h3 class="dash-25">{{$value}}</h3>
					</div>
					<div class="progress mb-1">
						@php
							$bg = [
									'bg-primary',
									'bg-secondary',
									'bg-success',
									'bg-danger',
									'bg-warning',
									'bg-info',
									
									'bg-dark',
								
									
								];

						@endphp
						<div aria-valuemax="100" aria-valuemin="0" aria-valuenow="70" class="progress-bar {{$bg[array_rand($bg)]}} progress-bar-xs wd-70p" role="progressbar"></div>
					</div>
					<div class="expansion-label d-flex">
						<span class="text-muted">{{trans("home.$key")}}</span>
						<span class="ml-auto">{{$value}}</span>
					</div>
				</div>
			</div>
		</div>
		@endforeach
	</div>
	<!--End  Row -->

	<!-- Row-->
	<div class="row">
		<div class="col-sm-12 col-xl-12 col-lg-12">
			<div class="card custom-card">
				<div class="card-body">
					<div>
						<h6 class="card-title mb-1">{{trans('home.Orders Summary')}}</h6>
						<p class="text-muted card-sub-title">{{trans('home.list of recent 10 orders')}}</p>
					</div>
					<div class="table-responsive">
						<table class="table table-bordered text-nowrap mb-0">
							<thead>
								<tr>
									<th>#No</th>
									<th>{{trans('home.order_number')}}</th>
									<th>{{trans('home.order_date')}}</th>
									<th>{{trans('home.order_user')}}</th>
									<th>{{trans('home.order_address')}}</th>
									<th>{{trans('home.order_note')}}</th>
									<th>{{trans('home.order_phone_numbers')}}</th>
									<th>{{trans('home.order_status')}}</th>
								</tr>
							</thead>
							<tbody>

								@foreach($orders as $key=>$order)
									<tr>
										<td>{{$key+1}}</td>
										<td>{{$order->order_number}}</td>
										<td>{{date('Y-m-d', strtotime($order->created_at ))}}</td>
										<td>{{$order->user->name}}</td>
										<td>{{$order->address->full_address}}</td>
										<td>{{$order->note}}</td>
										<td>{{$order->address->phone}}</td>
										<td>
											<span class="badge badge-primary">{{ $order->status?->name}}</span>
										</td>
									</tr>
								@endforeach

							</tbody>
						</table>
					</div>
				</div>
			</div>
		</div>
	</div>
	<!-- End Row -->

</div>



@endsection
