@extends('layouts.admin')
<title>{{trans('home.edit_attribute')}}</title>
@section('content')

<div class="container-fluid">
    <!-- Page Header -->
    <div class="page-header">
        <div>
            <h2 class="main-content-title tx-24 mg-b-5">{{trans('home.attributes')}}</h2>
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="{{url('/admin')}}">{{trans('home.admin')}}</a></li>
                <li class="breadcrumb-item"><a href="{{url('admin/attributes')}}">{{trans('home.attributes')}}</a></li>
                <li class="breadcrumb-item active" aria-current="page">{{trans('home.edit_attribute')}}</li>
            </ol>
        </div>
    </div>

    <!-- Row-->
    <div class="row">
        <div class="col-sm-12 col-xl-12 col-lg-12">
            <div class="card custom-card overflow-hidden">
                <div class="card-body">
                    <div>
                        <h6 class="card-title mb-1">{{trans('home.edit_attribute')}}</h6>
                    </div>
                    <form action="{{ route('attributes.update',[$attribute->id]) }}" method="POST" enctype="multipart/form-data">
                        @csrf
                        @method('PUT')

                        <div class="border">


                            <div class="card-body tab-content">
                                <!-- Tab 1: Attribute Details -->
                                <div class="tab-pane active show" id="tab1">
                                    <div class="row">
                                        <div class="form-group col-md-6">
                                            <label>{{trans('home.name_en')}}</label>
                                            <input class="form-control" name="name_en" type="text" value="{{ $attribute->name_en }}" placeholder="{{trans('home.name_en')}}" required>
                                        </div>

                                        <div class="form-group col-md-6">
                                            <label>{{trans('home.name_ar')}}</label>
                                            <input class="form-control" name="name_ar" type="text" value="{{ $attribute->name_ar }}" placeholder="{{trans('home.name_ar')}}">
                                        </div>

                                        <div class="form-group col-md-12">
                                            <label class="ckbox">
                                                <input name="status" value="1" type="checkbox" {{ $attribute->status ? 'checked' : '' }}><span class="tx-13">{{trans('home.publish')}}</span>
                                            </label>
                                        </div>
                                    </div>
                                </div>

                                <!-- Attribute Values Table-->

                                @include('admin.attribute-values.index')

                                <!-- End Attribute Values -->
                            </div>

                            <div class="form-group col-md-12 mt-3">
                                <button type="submit" class="btn btn-success">{{trans('home.save')}}</button>
                                <a href="{{ route('attributes.index') }}">
                                    <button type="button" class="btn btn-danger mr-1">{{trans('home.cancel')}}</button>
                                </a>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>

@endsection
