@extends('layouts.admin')
<title>{{trans('home.contactUsMessage')}}</title>
@section('content')

<div class="container-fluid">

        <!-- Page Header -->
        <div class="page-header">
            <div>
                <h2 class="main-content-title tx-24 mg-b-5">{{trans('home.commercial_request')}}</h2>
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="{{url('/admin')}}">{{trans('home.admin')}}</a></li>
                    <li class="breadcrumb-item"><a href="{{ route('contact_messages.index') }}">{{trans('home.commercial_request')}}</a></li>
                    <li class="breadcrumb-item active" aria-current="page">{{trans('home.commercial_request')}}</li>
                </ol>
            </div>
        </div>
        <!-- End Page Header -->

        <!-- Row-->
        <div class="row">

            <div class="ol-sm-12 col-xl-12 col-lg-12">
				<div class="card custom-card">
					<div class="">
						<div class="main-content-body main-content-body-contacts">
							<div class="main-contact-info-header pt-3">
								<div class="media">
									<div class="media-body">
										<h4>{{$message->name}}</h4>
									</div>
								</div>
							</div>
							<div class="main-contact-info-body">
								<div>
									<h6>{{trans('home.commercial_request')}}</h6>
									<p>{{$message->note}}</p>
								</div>
								<div class="media-list">
									<div class="media">
										<div class="media-body">
											<div>
												<label>{{trans('home.email')}}</label> <span class="tx-medium">{{$message->email}}</span>
											</div>
											<div>
												<label>{{trans('home.phone')}}</label> <span class="tx-medium">{{$message->phone}}</span>
											</div>

											<div>

												<label>{{trans('home.type_of_activity')}}</label> <span class="tx-medium">{{$message->type_of_activity ?? ''}}</span>
											</div>
											<div>
												<label>{{trans('home.category')}}</label> <span class="tx-medium">{{$message->category ?? ''}}</span>
											</div>
											<div>
												<label for="price_category">{{trans('home.price_category')}}</label> <span class="tx-medium">{{$message->price_category ?? ''}}</span>
											</div>
											<div>
												<label for="address"></label>
												<span class="tx-medium">{{$message->full_address}}</span>
											</div>
										</div>
									</div>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
        </div>
        <!-- End Row -->
    </div>

@endsection
