<?php

namespace Database\Seeders;

use App\Models\Slider;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use Faker\Factory as Faker;
use Mcamara\LaravelLocalization\Facades\LaravelLocalization;

class TopHeaderSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $faker = Faker::create();

        Slider::create([
            'title_ar' => 'تسوق الان',
            'title_en' =>'Shop Now',
            'text_ar' => $faker->sentence,
            'text_en' => $faker->sentence,
            'link' =>  LaravelLocalization::localizeUrl('products'),
            'type' => 'topHeader',
            'order' => '1'
        ]);

        Slider::create([
            'title_ar' => 'تسوق الان',
            'title_en' =>'Shop Now',
            'text_ar' => $faker->sentence,
            'text_en' => $faker->sentence,
            'link' =>  LaravelLocalization::localizeUrl('products'),
            'type' => 'topHeader',
            'order' => '2'
        ]);
    }
}
