<?php

namespace Database\Seeders;

use App\Models\Category;
use App\Models\Product;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class ProductSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run()
    {
        // Get all leaf categories (categories without children)
        $leafCategories = Category::whereDoesntHave('subcategories')
            ->whereNotNull('parent_id') // Only subcategories
            ->get();

        // Create products for each leaf category
        $leafCategories->each(function ($category) {
            Product::factory()
                ->count(5)
                ->create(['category_id' => $category->id]);
        });
    }
}
