<?php

namespace Database\Seeders;

use App\Helpers\Media;
use App\Models\Product;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class ProductImageSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        Product::whereNull('main_image')
            ->orWhereNull('second_image')
            ->chunk(100, function ($products) {
                foreach ($products as $product) {

                    // 1. Create a fake uploaded file
                    $main_image_file = Media::generateFakeUploadedFile(
                        prefix: 'product',
                        extension: 'webp'
                    );
                    // 2. Use your existing Media helper (exactly as you have it) 
                    $main_image = Media::uploadAndAttachImage($main_image_file, 'products') ?? null;

                    $second_image_file = Media::generateFakeUploadedFile(
                        prefix: 'product',
                        extension: 'webp'
                    );
                    // 2. Use your existing Media helper (exactly as you have it) 
                    $second_image = Media::uploadAndAttachImage($second_image_file, 'products') ?? null;


                    $product->update([
                        'main_image' => $main_image,
                        'second_image' => $second_image,
                    ]);
                }
            });
    }
}
