<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('governorates', function (Blueprint $table) {
            $table->id();
            $table->string('name_ar');
            $table->string('name_en');
            $table->foreignId('country_id')->constrained('countries')->onDelete('cascade');
            $table->integer('shipping_fees')->default(0);
            $table->boolean('status')->nullable()->default(1);
            $table->unique(['name_ar' , 'country_id']);
            $table->unique(['name_en' , 'country_id']);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('governorates');
        
    }
};
