<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('products', function (Blueprint $table) {
            $table->id();
            $table->string('name_ar',255);
            $table->string('name_en',255);
            $table->string('code',10)->unique();
            $table->foreignId('category_id')->nullable()->constrained('categories')->nullOnDelete();
            $table->foreignId('brand_id')->nullable()->constrained('brands')->nullOnDelete();
            $table->integer('viewing_count')->nullable()->default(0);
            $table->integer('order')->default(0);
            $table->decimal('price',10,2)->default(0);
            $table->integer('quantity')->default(0);
            $table->longText('short_text_ar')->nullable();
            $table->longText('short_text_en')->nullable();
            $table->longText('text_ar')->nullable();
            $table->longText('text_en')->nullable();
            $table->string('main_image',50);
            $table->string('alt_main_image',50)->nullable();
            $table->string('second_image',50)->nullable();
            $table->string('alt_second_image',50)->nullable();
            $table->boolean('status')->default(true);
            $table->boolean('featured')->default(false);
            $table->boolean('home')->default(0);
            $table->string('link_ar',255)->unique();
            $table->string('link_en',255)->unique();
            $table->string('meta_title_ar')->nullable();
            $table->string('meta_title_en')->nullable();
            $table->longText('meta_description_ar')->nullable();
            $table->longText('meta_description_en')->nullable();
            $table->boolean('index')->default(0)->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('products');
    }
};
