<?php

namespace Database\Factories;

use App\Helpers\Media;
use App\Models\Category;
use App\Models\Product;
use Illuminate\Database\Eloquent\Factories\Factory;
use Illuminate\Support\Str;

class CategoryFactory extends Factory
{
    public function definition(): array
    {
        // 1. Create a fake uploaded file
        $imageFile = Media::generateFakeUploadedFile(
            prefix: 'category',
            extension: 'webp'
        ) ;
        // 2. Use your existing Media helper (exactly as you have it) 
        $imageName = Media::uploadAndAttachImage($imageFile, 'categories')?? null;

        return [
            'name_ar' => fake()->unique()->words(2, true),
            'name_en' => fake()->unique()->words(2, true),
            'order' => fake()->numberBetween(1, 100),
            'parent_id' => null,
            'text_ar' => fake('ar_SA')->paragraph(),
            'text_en' => fake()->paragraph(),
            'status' => fake()->boolean(70),
            'image' => $imageName, // Stores just the filename
            'link_ar' => Str::slug(fake()->unique()->words(2, true)),
            'link_en' => Str::slug(fake()->unique()->words(2, true)),
            'meta_title_ar' => fake('ar_SA')->optional()->sentence,
            'meta_title_en' => fake()->optional()->sentence(),
            'meta_description_ar' => fake('ar_SA')->optional()->paragraph(),
            'meta_description_en' => fake()->optional()->paragraph(),
            'index' => fake()->boolean(70),

        ];
    }

    public function parent(?int $parentId = null): static
    {
        return $this->state(fn() => ['parent_id' => $parentId]);
    }

}
