<?php

namespace App\Traits\PlaceOrder;

use App\Models\Order;
use App\Models\OrderProduct;
use App\Models\OrderStatus;
use App\Traits\Checkout\CouponTrait;

trait OrderProcessTrait
{
    use CouponTrait;
    public static function createOrder($userId, $addressId, $data, $cart, $address)
    {

        $freeShippingThreshold = (float)config('site_free_amount', 0);
        
        // Total price of items in the cart before applying coupon or discount
        $cartTotal = (float)$cart->items_total_price;
        $shipping_fees = 0;

        if ($cartTotal < $freeShippingThreshold) {
            $shipping_fees = (float)$address->Governorate->shipping_fees
                            + (float)$address->area->shipping_fees;
        }


        return  Order::create([
            'user_id' => $userId,
            'address_id' =>  $addressId,
            'payment_method_id' => $data['payment_id'],
            'payment_fees' => $data['payment_fees'],
            'shipping_fees' =>  $shipping_fees,
            'products_price' => $cart->total_price,
            'total_price' => ($cart->total_price + $shipping_fees),
            'note' => $data['note'],
        ]);
    }
    public static function processOrderItems($cart, $order)
    {

        foreach ($cart->items as $item)

            OrderProduct::create([
                'order_id' => $order->id,
                'product_stock_id' => $item->product_stock_id,
                'price_before_discount' => $item->productStock->price,
                'discount_id' => $item->productStock->product->discount_id,
                'price_after_discount' => $item->price,
                'quantity' => $item->quantity,
                'total' => $item->price * $item->quantity,
            ]);
        // update product quantity
        $item->productStock->update(['stock' => $item->productStock->stock - $item->quantity]);

        $cart->delete();
    }

    public static function createOrderStatus($order)
    {
        OrderStatus::create(
            [
                'order_id' => $order->id,
                'status' => 'pending'
            ]
        );
    }
}
