<?php
namespace App\Traits\Checkout;

use App\Models\Coupon;
use App\Models\CouponUsed;

trait CouponTrait{

    public static function applyCoupon($cart ,$couponCode)
    {

        $coupon = Coupon::where('code', $couponCode)->first();

        if ($coupon) {
            // Check if the coupon can be used
            [$canUse, $errorMessage] = $coupon->canUse($cart);
        
            if ($canUse) {
                // Apply the coupon
                $cart->update([
                    'coupon_id' => $coupon->id,
                    'discount_amount' => $coupon->coupon_amount,
                    'total_price' => ($cart->products_price - $coupon->coupon_amount),
                ]);
                $updatedCart = $cart->fresh();
        
                // Return success response
                return response()->json([
                    'status' => true,
                    'coupon' => $coupon,
                    'cart_total_price' => round($updatedCart->total_price, 2),
                    'message' => __('home.Coupon applied successfully.')
                ]);
            } else {
                // Return error response with specific message
                return response()->json([
                    'status' => false,
                    'message' => $errorMessage,
                ], 400);
            }
        } else {
            // Coupon not found
            return response()->json([
                'status' => false,
                'message' => __('home.Sorry, Coupon Not Found.'),
            ], 400);
        }
    }

    public static function couponUsed($cart,$userId,$order)
    {
        if($cart->coupon_id)
        {
            CouponUsed::create(['coupon_id'=>$cart->coupon_id,'user_id'=> $userId]);
            $order->update([
                'coupon_id' => $cart->coupon_id,
                'coupon_discount' => $cart->coupon->coupon_amount
            ]);
        }
    }
}