<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class VariantValue extends Model
{
    use HasFactory;
    protected $table = 'variant_values';
    protected $fillable = [
        'variant_id',
        'value_id',

    ];

    public function variant()
    {
        return $this->belongsTo(ProductVariant::class, 'variant_id');
    }
    public function value()
    {
        return $this->belongsTo(AttributeValue::class, 'value_id');
    }
}
