<?php

namespace App\Models;

use App\Helpers\Helper;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class SiteAddress extends Model
{
    use HasFactory;

    protected $table = 'site_addresses';

    protected $fillable = [
        'title_en', 'title_ar', 'address_ar', 'address_en', 'email',
        'phone1', 'code1', 'phone2', 'code2', 'map_url', 'order', 'status'
    ];

    // Remove the constructor or modify it
    public function __construct(array $attributes = [])
    {
        parent::__construct($attributes);
    }

    public function getTitleAttribute()
    {
        return $this->{'title_' . Helper::getLang()};
    }

    public function getTextAttribute()
    {
        return $this->{'text_' . Helper::getLang()};
    }

    public function getAddressAttribute()
    {
        return $this->{'address_' . Helper::getLang()};
    }

    public function scopeActive($query)
    {
        return $query->whereStatus(1);
    }

    public function scopeUnactive($query)
    {
        return $query->whereStatus(0);
    }
}