<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class SampleRequest extends Model
{
    use HasFactory;

    protected $table = 'sample_requests';

    protected $fillable = [
        'user_id',
        'session_id',
        'product_id',
        'product_variant_id',
    ];

    public function user()
    {
        return $this->belongsTo(User::class);
    }
    public function product()
    {
        return $this->belongsTo(Product::class);
    }
    public function variant()
    {
        return $this->belongsTo(ProductVariant::class,'product_variant_id');
    }
    
    public function sampleRequests()
    {
        return $this->hasMany(SampleRequest::class);
    }
}
