<?php

namespace App\Models;

use App\Helpers\Helper;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class PaymentMethod extends Model
{
    use HasFactory;
    private $lang;
    public function __construct(array $attributes = [])
    {
        parent::__construct($attributes);

        // Set the current locale dynamically
        $this->lang = Helper::getLang();
    }
    protected $fillable = ['name_en', 'name_ar', 'text_en', 'text_ar', 'fees', 'logo', 'status'];
    protected $table = 'payment_methods';

    public function getImageSourceAttribute($value)
    {

        return Helper::imageIsExists($this->logo, 'paymentMethods') ?  Helper::uploadedImagesPath('paymentMethods', $this->logo)   : Helper::noImage();
    }



    public function getNameAttribute()
    {
       
        return $this->{'name_' . $this->lang};
    }

    public function payments()
    {
        return $this->hasMany(Payment::class);
    }


}
