<?php

namespace App\Http\Requests\Website\UserBoard;

use Illuminate\Foundation\Http\FormRequest;

class UpdateAddressRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'phone' => ['nullable', 'regex:/^01\d{9}$/'],
            'country_id' => ['nullable','exists:countries,id'],
            'Governorate_id' => ['nullable','exists:Governorates,id'],
            'area_id' => ['nullable','exists:areas,id'],
            'address' => ['nullable'],
            'is_primary' => ['nullable','boolean'],
        ];
    }
}
