<?php

namespace App\Http\Controllers\website;

use App\Http\Controllers\Controller;
use App\Models\Product;
use App\Models\WishList;
use App\Traits\Carts\CartTrait;
use App\Traits\Carts\GuestCartTrait;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class WishListController extends Controller
{
    use CartTrait, GuestCartTrait;
    
    public function addToWishList(Request $request)
    {
        $productId = $request->input('productId');

        if (Auth::check()) {

            $userId = auth()->user()->id;

            WishList::updateOrCreate(
                ['user_id' => $userId, 'product_id' => $productId],
                ['user_id' => $userId, 'product_id' => $productId]
            );

            $wishListCount = WishList::where('user_id', $userId)->count();
        } else {

            $session_id = $this->getOrGenerateGuestCartSession();

            WishList::updateOrCreate(
                ['session_id' => $session_id, 'product_id' => $productId],
                ['session_id' => $session_id, 'product_id' => $productId]
            );

            $wishListCount = WishList::where('session_id', $session_id)->count();
        }

        return response()->json([
            'status' => true,
            'wishListCount' => $wishListCount,
        ]);
    }


    public function removeWishListItem(Request $request)
    {
        $productId = $request->input('productId');
        if (Auth::check()) {

            $userId = auth()->user()->id;

            WishList::where('user_id', $userId)->where('product_id', $productId)->delete();


            $wishListCount = WishList::where('user_id', $userId)->count();
        } else {

            $session_id = $this->getOrGenerateGuestCartSession();

            WishList::where('session_id', $session_id)->where('product_id', $productId)->delete();

            $wishListCount = WishList::where('session_id', $session_id)->count();
        }
        return response()->json([
            'status' => true,
            'wishListCount' => $wishListCount,
        ]);
    }

    public function viewWishlist()
    {

        if (Auth::check()) {

            $userId = auth()->user()->id;

            $productIds =   WishList::where('user_id', $userId)->pluck('product_id');

            $wishListProducts = Product::whereIn('id', $productIds)->get();
        } else {

            $session_id = $this->getOrGenerateGuestCartSession();

            $productIds =   WishList::where('session_id', $session_id)->pluck('product_id');

            $wishListProducts = Product::whereIn('id', $productIds)->get();
        }

        return view('website.wishlist', compact('wishListProducts'));
    }
}
