<?php

namespace App\Http\Controllers\website\UserBoard;

use App\Http\Controllers\Controller;
use App\Http\Requests\Website\UserBoard\StoreAddressRequest;
use App\Http\Requests\Website\UserBoard\UpdateAddressRequest;
use App\Models\Address;
use App\Models\Area;
use App\Models\Country;
use App\Models\Governorate;
use App\Models\UserAddress;
use GrahamCampbell\ResultType\Success;
use Illuminate\Http\Request;

class UserAddressController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {

        $data['countries'] = Country::where('status', 1)->get();
        $data['governorates'] = Governorate::where('status', 1)->get();
        return view('website.userBoard.addresses', $data);
    }


    /**
     * Store a newly created resource in storage.
     */
    public function store(StoreAddressRequest $request)
    {
        $validatedData = $request->validated();
        dd($validatedData);

        if (isset($validatedData['is_primary']) &&  auth()->user()->primary_address) {
            auth()->user()->primary_address->update(['is_primary' => 0]);
        }
        $validatedData['user_id'] = auth()->user()->id;
        
        UserAddress::create($validatedData);

        return redirect()->back()->with(['success',__('home.address_data_stored_successfully')]);
    }




    /**
     * Update the specified resource in storage.
     */
    public function update(UpdateAddressRequest $request, UserAddress $address)
    {

        $validatedData = $request->validated();

        if (isset($validatedData['is_primary']) &&  auth()->user()->primary_address) {
            auth()->user()->primary_address->update(['is_primary' => 0]);
            $validatedData['is_primary'] = 1;
        }else{
            $validatedData['is_primary'] = 0 ;
        }


        $address->update($validatedData);

        return redirect()->back()->with('success', trans('home.address_data_updated_successfully'));
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy( UserAddress $address)
    {
      // Call the delete method
    $result = $address->delete();

    // Check if the result is an error message (string)
    if (is_string($result)) {
        return redirect()->back()->with('error', $result);
    }

    // Check if the deletion was successful
    if ($result) {
        return redirect()->back()->with('success', __('home.address_deleted_successfully'));
    } else {
        return redirect()->back()->with('error', __('home.an_messages.error_entering_data'));
    }
       
    }
}
