<?php

namespace App\Http\Controllers\website;

use App\Http\Controllers\Controller;
use App\Http\Requests\Website\PlaceOrderRequest;
use App\Services\OrderService;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Log;

class PlaceOrderController extends Controller
{

    public function __invoke(PlaceOrderRequest $request)
    {

        try {
            
            $validatedData = $request->validated();

            $order =  (new OrderService($validatedData))->placeOrder();

            return view('website.order-thank',compact('order'));

        } catch (\Exception $e) {
            Log::error('Order placement failed: ' . $e->getMessage(), [
            'trace' => $e->getTraceAsString(),
            'data' => $request->all()
        ]);
            return redirect()->back()->withErrors(['error' => 'Failed to place order. Please try again later. ' . $e->getMessage()]);
        }
    }
}