<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Subscribe;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class SubscribeController extends Controller
{
    public function index()
    {
  

        $subscribers = Subscribe::orderBy('created_at', 'desc')->get();

        return view('admin.Subscribers.index', compact('subscribers'));
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(Request $request)
    {
        $selectedIds = $request->input('id');

        DB::beginTransaction();
        try {
           
            Subscribe::whereIn('id', $selectedIds)->delete();

            DB::commit();

            return response()->json(['success' => true, 'message' => __('home.your_items_deleted_successfully')]);
        } catch (\Exception $e) {

            DB::rollBack();
            return response()->json(['error' => true, 'message' => __('home.an error has occurred. ' . $e->getMessage())]);
        }
    }
}
