<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Http\Requests\ReportRequest;
use App\Models\Brand;
use App\Models\Category;
use App\Models\OrderShipmentStatus;
use App\Models\OrderStatus;
use App\Models\PaymentMethod;
use App\Models\Product;
use App\Services\OrderReportService;
use Illuminate\Http\Request;

class ReportController extends Controller
{
    public function index()
    {
        $data['brands'] = Brand::all();
        $data['categories'] = Category::all();
        $data['paymentMethods'] = PaymentMethod::whereHas('payments')->get();
        $data['products'] = Product::all();
        $data['orderStatuses'] = OrderStatus::all();
        $data['orderShipmentStatuses'] = OrderShipmentStatus::whereHas('orderShipments')->get();
        return view('admin.reports.orderReport.index', $data);
    }


    public function generate(ReportRequest $request , OrderReportService $orderReportService)
    {
        $validated_data =  $request->validated();
        $orders =  $orderReportService->generateReport($validated_data);

        return view('admin.reports.orderReport.orderReportResult', compact('orders'));
      
    }

    public  function export(ReportRequest $request , OrderReportService $orderReportService) 
    {
        $validated_data =  $request->validated();

        $orders =  $orderReportService->generateReport($validated_data);
      
        return $orderReportService->exportToCsv($orders);
    }

}
