<?php

namespace App\Http\Controllers\Admin\Products;

use App\Helpers\Helper;
use App\Helpers\Media;
use App\Http\Controllers\Controller;
use App\Models\Image;
use App\Models\Product;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class ProductImageController extends Controller
{
   public function index(Product $product)
   {
    $data['product'] = $product;

    return view('admin.products.images.index',$data);

   }

   public function store(Request $request, Product $product)
   {
       $this->validate($request, [
           'images' => 'required|array',
           'images.*' => 'image|mimes:webp|max:1024',
       ]);

       foreach ($request->file('images') as $key => $file) {

        $filename =   Media::uploadAndAttachImage($file, 'products/images');

        Image::create([
            'image'=> $filename ,
            'imageable_id' => $product->id ,
            'imageable_type' => $product->getMorphClass()
        ]);
    }

       return redirect()->route('products.images.index', $product->id)
           ->with('success', __('home.your_items_added_successfully'));
   }

    public function destroy(Request $request, Product $product , Image $image)
    {
        DB::beginTransaction();
        try{
            $image->delete();

            Media::removeFile('products/images', $image->image);
       
            DB::commit();
            return redirect()->route('products.images.index', $product->id)
                 ->with('success', __('home.your_item_deleted_successfully'));
   
        }catch(\Exception $e){
            DB::rollBack();
            return redirect()->back()->withErrors(__('home.an error occurred: ' . $e->getMessage()));
          
        }
    }

}
