<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Category;
use App\Models\Country;
use App\Models\Lang;
use App\Models\Governorate;
use App\Models\Page;
use App\Models\Attribute;
use App\Models\Color;
use App\Models\Brand;
use App\Models\Product;
use App\Models\Menu;
use App\Models\MenuItem;
use App\Models\Order;
use Carbon\Carbon;

use App\Models\User;

use App\Services\AdminService;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class AdminController extends Controller
{
    /////////// function return admin index view //////////


    public function index()
    {
        //------------------------------
        /////     Orders Report     /////

        $data['reports']['totalOrders'] = Order::count();

        $data['reports']['totalOrdersCost'] = Order::sum('total_amount');
        
        $data['reports']['currentMonthOrdersCost'] = Order::whereYear('created_at', Carbon::now()->year)
        ->whereMonth('created_at', Carbon::now()->month)
        ->sum('total_amount');

        $data['reports']['lastMonthOrdersCost'] = Order::whereYear('created_at', Carbon::now()->year)
        ->where('created_at', '>=', Carbon::now()->subMonth()->month)
        ->sum('total_amount');

        $data['reports']['currentMonthOrders'] = Order::whereYear('created_at', Carbon::now()->year)
            ->whereMonth('created_at', Carbon::now()->month)
            ->count();

        $data['reports']['pendingOrders'] = Order::with(['status' => function ($q) {
            $q->where('name', 'Pending');
        }])->count();

        $data['reports']['processingOrders'] = Order::with(['status' => function ($q) {
            $q->where('name', 'Processing');
        }])->count();

        $data['reports']['confirmedOrders'] = Order::with(['status' => function ($q) {
            $q->where('name', 'Confirmed');
        }])->count();

        $data['reports']['ShippedOrders'] = Order::with(['status' => function ($q) {
            $q->where('name', 'Shipped');
        }])->count();

        $data['reports']['OutForDeliveryOrders'] = Order::with(['status' => function ($q) {
            $q->where('name', 'Out for Delivery');
        }])->count();


        $data['reports']['DeliveredOrders'] = Order::with(['status' => function ($q) {
            $q->where('name', 'Delivered');
        }])->count();

        $data['reports']['CancelledOrders'] = Order::with(['status' => function ($q) {
            $q->where('name', 'Cancelled');
        }])->count();


        $data['reports']['RefundedOrders'] = Order::with(['status' => function ($q) {
            $q->where('name', 'Refunded');
        }])->count();

        $data['reports']['FailedOrders'] = Order::with(['status' => function ($q) {
            $q->where('name', 'Failed');
        }])->count();
        
        $data['orders'] = Order::with([
            'user',
            'status',
            'payment.paymentMethod',
            'address.governorate',
            'address.country',
            'items.product',
        ])->orderBy('id', 'DESC')->take(10)->get();


        //--------------------------------//
        /////     Products Report     /////

        $products = Product::query();
        $data['reports']['productCount'] = $products->count();
        $data['reports']['availableProductNumber'] = $products->active()->count();

        //--------------------------------//
        /////     uesrs Report     /////

        $data['reports']['usersCount'] = User::count();

        //--------------------------------//
        /////     categories Report     /////

        $data['reports']['categoriesNumber'] = Category::count();

        /////     brands Report     /////

        $data['reports']['brandsNumber'] = Brand::count();

        return view('admin.index', $data);
    }

    ///// function set session lang of the app////
    public function setlang($lang)
    {
        $langs = ['en', 'ar'];
        if (in_array($lang, $langs)) {
            session(['lang' => $lang]);
            return redirect()->back();
        }
    }

    public function changeStatus(Request $request , AdminService $adminService)
    {
        $selectedIds = $request->input('selectedIds');

        $model = $request->input('modelName');

        $updated =  $adminService->changeStatus($model, $selectedIds);

        if ($updated) {
            // Set a flash message in the session
            session()->flash('success', __('status updated successfully'));

            return response()->json(['success' => true, 'message' => __('status updated successfully')]);
        } else {
            return response()->json(['success' => false, 'message' => __('status update failed')]);
        }
    }


    public function switchTheme()
    {

        $user = User::find(Auth::user()->id);
        if ($user->theme == 'default') {
            $user->theme = 'dark';
            $user->save();
        } else {
            $user->theme = 'default';
            $user->save();
        }

        return back();
    }
}
