<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use Illuminate\Support\Facades\DB;

class MigrateOldCategories extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'app:migrate-old-categories';

    protected $description = 'Migrate categories from old DB to new DB';

    /**
     * The console command description.
     *
     * @var string
     */
   

    /**
     * Execute the console command.
     */
    public function handle()
    {
        DB::connection('mysql_old')->disableQueryLog();

        $categories = DB::connection('mysql_old')
            ->table('categories')
            ->get();
    
       
       
        foreach ($categories as $key => $old) {
            DB::table('categories')->insert([
                'id' => $old->id,
                'name_ar' => $old->name_ar,
                'name_en' => $old->name_en,
                'order' => $key + 1,
                // 'parent_id' => $old->parent_id,
                'text_ar' => $old->desc_ar,
                'text_en' => $old->desc_en,
                'link_ar' => $old->link_ar,
                'link_en' => $old->link_en,
                'image' => null,
                'icon' => null, 
                'status' => $old->status ?? 1,     
                'meta_title_ar' => $old->meta_title_ar,
                'meta_title_en' => $old->meta_title_en,
                'meta_description_ar' => $old->meta_desc_ar,
                'meta_description_en' => $old->meta_desc_en,
                'index' => $old->meta_robots,
                'created_at' => $old->created_at,
                'updated_at' => $old->updated_at,
            ]);
        }

        $this->info('Migration complete.');
    }
}
