<?php if(!empty($metatags)): ?>
    
    <meta charset="<?php echo e($metatags['charset'] ?? 'utf-8'); ?>">
    <meta name="viewport" content="<?php echo e($metatags['viewport'] ?? 'width=device-width, initial-scale=1.0'); ?>">
    <meta http-equiv="Content-Language" content="<?php echo e($metatags['language'] ?? 'en'); ?>">
    <meta name="robots" content="<?php echo e($metatags['robots'] ?? 'index, follow'); ?>">
    <meta name="description" content="<?php echo e($metatags['description'] ?? ''); ?>">
    <?php if(!empty($metatags['keywords'])): ?>
        <meta name="keywords" content="<?php echo e($metatags['keywords']); ?>">
    <?php endif; ?>
    <meta name="author" content="<?php echo e($metatags['author'] ?? ''); ?>">
    <title><?php echo e($metatags['title'] ?? config('settings.site_name')); ?></title>

    <?php if(!empty($metatags['time'])): ?>
        <meta name="time" content="<?php echo e($metatags['time']); ?>">
    <?php endif; ?>


    
    <?php if(!empty($metatags['canonical'])): ?>
        <link rel="canonical" href="<?php echo e($metatags['canonical']); ?>">
    <?php endif; ?>

    
    <link rel="icon" href="<?php echo e(\App\Helper\Path::FavIcon()); ?>" type="image/x-icon">
    <link rel="apple-touch-icon" href="<?php echo e(\App\Helper\Path::FavIcon()); ?>">

    
    <meta property="og:title" content="<?php echo e($metatags['og_title'] ?? ($metatags['title'] ?? '')); ?>">
    <meta property="og:description" content="<?php echo e($metatags['og_description'] ?? ($metatags['description'] ?? '')); ?>">
    <meta property="og:url" content="<?php echo e($metatags['og_url'] ?? url()->current()); ?>">
    <meta property="og:image" content="<?php echo e($metatags['og_image'] ?? asset('images/default-og.jpg')); ?>">
    <meta property="og:image:width" content="1200">
    <meta property="og:image:height" content="630">
    <meta property="og:image:alt" content="<?php echo e($metatags['og_title'] ?? ($metatags['title'] ?? '')); ?>">
    <meta property="og:type" content="<?php echo e($metatags['og_type'] ?? 'website'); ?>">
    <meta property="og:site_name" content="<?php echo e($metatags['og_site_name'] ?? config('settings.site_name')); ?>">
    <meta property="og:locale" content="<?php echo e($metatags['og_locale'] ?? app()->getLocale()); ?>">

    
    <meta name="twitter:card" content="summary_large_image">
    <meta name="twitter:title" content="<?php echo e($metatags['twitter_title'] ?? ($metatags['title'] ?? '')); ?>">
    <meta name="twitter:description"
        content="<?php echo e($metatags['twitter_description'] ?? ($metatags['description'] ?? '')); ?>">
    <meta name="twitter:image" content="<?php echo e($metatags['twitter_image'] ?? asset('images/default-og.jpg')); ?>">
    <?php if(!empty($metatags['twitter_site'])): ?>
        <meta name="twitter:site" content="<?php echo e($metatags['twitter_site']); ?>">
    <?php endif; ?>
    <?php if(!empty($metatags['twitter_creator'])): ?>
        <meta name="twitter:creator" content="<?php echo e($metatags['twitter_creator']); ?>">
    <?php endif; ?>

    
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link rel="dns-prefetch" href="//www.google-analytics.com">
    <link rel="dns-prefetch" href="//www.googletagmanager.com">
<?php endif; ?>


<?php if(!empty($schema)): ?>
    <script type="application/ld+json">
<?php echo json_encode($schema, JSON_UNESCAPED_SLASHES | JSON_UNESCAPED_UNICODE); ?>

</script>
<?php else: ?>
    
    <script type="application/ld+json">
<?php echo json_encode([
    '@context' => 'https://schema.org',
    '@type' => 'WebPage',
    'name' => $metatags['title'] ?? config('settings.site_name'),
    'url' => $metatags['canonical'] ?? url()->current(),
    'description' => $metatags['description'] ?? ''
], JSON_UNESCAPED_SLASHES | JSON_UNESCAPED_UNICODE); ?>

</script>
<?php endif; ?>


<?php if(!empty($faq_schema)): ?>
    <script type="application/ld+json">
    <?php echo json_encode($faq_schema, JSON_UNESCAPED_SLASHES | JSON_UNESCAPED_UNICODE); ?>

</script>
<?php endif; ?>


<?php if(!empty($breadcrumb_schema)): ?>
    <script type="application/ld+json">
    <?php echo json_encode($breadcrumb_schema, JSON_UNESCAPED_SLASHES | JSON_UNESCAPED_UNICODE); ?>

</script>
<?php endif; ?>


<?php if(config('settings.google_tag_manager_id')): ?>
    <script>
        (function(w, d, s, l, i) {
            w[l] = w[l] || [];
            w[l].push({
                'gtm.start': new Date().getTime(),
                event: 'gtm.js'
            });
            var f = d.getElementsByTagName(s)[0],
                j = d.createElement(s),
                dl = l != 'dataLayer' ? '&l=' + l : '';
            j.async = true;
            j.src =
                'https://www.googletagmanager.com/gtm.js?id=' + i + dl;
            f.parentNode.insertBefore(j, f);
        })(window, document, 'script', 'dataLayer', '<?php echo e(config('settings.google_tag_manager_id')); ?>');
    </script>
<?php endif; ?>


<?php if(config('settings.google_analytics_id')): ?>
    <script async src="https://www.googletagmanager.com/gtag/js?id=<?php echo e(config('settings.google_analytics_id')); ?>"></script>
    <script>
        window.dataLayer = window.dataLayer || [];

        function gtag() {
            dataLayer.push(arguments);
        }
        gtag('js', new Date());
        gtag('config', '<?php echo e(config('settings.google_analytics_id')); ?>');
    </script>
<?php endif; ?>


<meta http-equiv="X-UA-Compatible" content="IE=edge">
<meta http-equiv="Content-Security-Policy" content="upgrade-insecure-requests">
<meta http-equiv="Strict-Transport-Security" content="max-age=31536000; includeSubDomains; preload">
<!-- Google reCAPTCHA -->
<?php /**PATH /home/webtest3/public_html/mepicom-new/resources/views/components/seo/head.blade.php ENDPATH**/ ?>