<x-dashboard.layout :title="__('dashboard.edit') . ' ' . $service->name">

    @section('style')
        <style>
            img {
                display: block !important;
            }

            .dz-hidden-input {
                position: absolute !important;
                top: 0px !important;
                left: 250px !important;
            }

            .sortable-container {
                cursor: move;
            }

            .sortable-container.sortable-ghost {
                opacity: 0.5;
            }

            .sortable-container.sortable-chosen {
                background-color: #f8f9fa;
                border: 2px dashed #007bff;
            }

            .drag-handle {
                cursor: move;
                position: absolute;
                top: 5px;
                right: 5px;
                background: rgba(0, 0, 0, 0.5);
                color: white;
                padding: 2px 6px;
                border-radius: 3px;
                font-size: 12px;
                z-index: 10;
            }

            .ai-loading {
                opacity: 0.6;
                pointer-events: none;
            }
        </style>
        <link href="https://cdnjs.cloudflare.com/ajax/libs/dropzone/4.0.1/min/dropzone.min.css" rel="stylesheet">
    @endsection

    <!-- Page Header -->
    <x-dashboard.partials.page-header :header="__('dashboard.edit') . ' ' . $service->name" :label_url="route('dashboard.services.index')" :label="__('dashboard.services')" />
    <!-- End Page Header -->

    <!-- Row-->
    <div class="row">
        <div class="col-sm-12 col-xl-12 col-lg-12">
            <div class="card">
                <div class="card-header d-flex justify-content-between">
                    <h4 class="card-title pt-3">{{ __('dashboard.edit') . ' ' . $service->name }}</h4>
                </div>

                <div class="card-body">
                    <form action="{{ route('dashboard.services.update', [$service->id]) }}" method="POST"
                        enctype="multipart/form-data">
                        @csrf
                        @method('PATCH')
                        <div class="row">

                            <div class="form-group col-md-4">
                                <label class="">{{ __('dashboard.name_en') }}</label>
                                <input class="form-control" name="name_en" type="text"
                                    value="{{ old('name_en', $service->name_en) }}"
                                    placeholder="{{ __('dashboard.name_en') }}">
                                @error('name_en')
                                    <div class="text-danger">{{ $message }}</div>
                                @enderror
                            </div>

                            <div class="form-group col-md-4">
                                <label class="">{{ __('dashboard.name_ar') }}</label>
                                <input class="form-control" name="name_ar" type="text"
                                    value="{{ old('name_ar', $service->name_ar) }}"
                                    placeholder="{{ __('dashboard.name_ar') }}">
                                @error('name_ar')
                                    <div class="text-danger">{{ $message }}</div>
                                @enderror
                            </div>

                            <div class="form-group col-md-2">
                                <label>{{ __('dashboard.order') }}</label>
                                <input class="form-control" name="order" type="number"
                                    value="{{ old('order', $service->order) }}"
                                    placeholder="{{ __('dashboard.order') }}">
                                @error('order')
                                    <div class="text-danger">{{ $message }}</div>
                                @enderror
                            </div>

                            <div class="form-group col-md-2">
                                <label for="parent">{{ __('dashboard.parent') }}</label>
                                <select class="form-control select2" name="parent_id">
                                    <option value="">{{ __('dashboard.no_parent') }}</option>
                                    @foreach ($services as $serviceItem)
                                        <option value="{{ $serviceItem->id }}"
                                            {{ old('parent_id', $service->parent_id) == $serviceItem->id ? 'selected' : '' }}>
                                            {{ $serviceItem->name }}
                                        </option>
                                    @endforeach
                                </select>
                                @error('parent_id')
                                    <div class="text-danger">{{ $message }}</div>
                                @enderror
                            </div>

                            <div class="col-12">
                                <hr>
                            </div>

                            <div class="form-group col-md-6">
                                <label>{{ __('dashboard.image') }} (225px * 225px max 1mb)</label>
                                <input type="file" class="form-control" name="image" accept="image/*">
                                @error('image')
                                    <div class="text-danger">{{ $message }}</div>
                                @enderror
                            </div>

                            <div class="form-group col-md-2">
                                <label for="">{{ __('dashboard.current_image') }}</label>
                                @if ($service->image_path)
                                    <img src="{{ $service->image_path }}" width="150" class="img-thumbnail">
                                @else
                                    <p class="text-muted">{{ __('dashboard.no_image') }}</p>
                                @endif
                            </div>

                            <div class="form-group col-md-4">
                                <label class="">{{ __('dashboard.alt_image') }}</label>
                                <input class="form-control" name="alt_image" type="text"
                                    placeholder="{{ __('dashboard.alt_image') }}"
                                    value="{{ old('alt_image', $service->alt_image) }}">
                            </div>

                            <div class="form-group col-md-6">
                                <label>{{ __('dashboard.icon') }} (50px * 50px max 1mb)</label>
                                <input type="file" class="form-control" name="icon" accept="image/*">
                                @error('icon')
                                    <div class="text-danger">{{ $message }}</div>
                                @enderror
                            </div>

                            <div class="form-group col-md-2">
                                <label for="">{{ __('dashboard.current_icon') }}</label>
                                @if ($service->icon_path)
                                    <img src="{{ $service->icon_path }}" width="150" class="img-thumbnail">
                                @else
                                    <p class="text-muted">{{ __('dashboard.no_icon') }}</p>
                                @endif
                            </div>

                            <div class="form-group col-md-4">
                                <label class="">{{ __('dashboard.alt_icon') }}</label>
                                <input class="form-control" name="alt_icon" type="text"
                                    placeholder="{{ __('dashboard.alt_icon') }}"
                                    value="{{ old('alt_icon', $service->alt_icon) }}">
                            </div>

                            <div class="col-12">
                                <hr>
                            </div>

                            <div class="form-group col-md-6">
                                <label class="">{{ __('dashboard.short_desc_en') }}</label>
                                <textarea class="form-control" name="short_desc_en" rows="3" placeholder="{{ __('dashboard.short_desc_en') }}">{{ old('short_desc_en', $service->short_desc_en) }}</textarea>
                                @error('short_desc_en')
                                    <div class="text-danger">{{ $message }}</div>
                                @enderror
                            </div>

                            <div class="form-group col-md-6">
                                <label class="">{{ __('dashboard.short_desc_ar') }}</label>
                                <textarea class="form-control" name="short_desc_ar" rows="3" placeholder="{{ __('dashboard.short_desc_ar') }}">{{ old('short_desc_ar', $service->short_desc_ar) }}</textarea>
                                @error('short_desc_ar')
                                    <div class="text-danger">{{ $message }}</div>
                                @enderror
                            </div>

                            <div class="col-12">
                                <hr>
                            </div>

                            <div class="form-group col-md-6">
                                <label class="">{{ __('dashboard.long_desc_en') }}</label>
                                <textarea class="form-control editor-textarea" id="long_desc_en" name="long_desc_en" rows="6"
                                    placeholder="{{ __('dashboard.long_desc_en') }}">{{ old('long_desc_en', $service->long_desc_en) }}</textarea>
                                @error('long_desc_en')
                                    <div class="text-danger">{{ $message }}</div>
                                @enderror
                            </div>

                            <div class="form-group col-md-6">
                                <label class="">{{ __('dashboard.long_desc_ar') }}</label>
                                <textarea class="form-control editor-textarea" id="long_desc_ar" name="long_desc_ar" rows="6"
                                    placeholder="{{ __('dashboard.long_desc_ar') }}">{{ old('long_desc_ar', $service->long_desc_ar) }}</textarea>
                                @error('long_desc_ar')
                                    <div class="text-danger">{{ $message }}</div>
                                @enderror
                            </div>

                            <!-- AI Content Generation Section -->
                            <div class="col-12">
                                <hr>
                                <h4 class="card-title">
                                    <i class="fas fa-robot"></i> {{ __('dashboard.ai_content_generation_with_ai') }}
                                </h4>
                                <p class="text-muted">{{ __('dashboard.ai_content_description') }}</p>

                                <div class="card border-primary">
                                    <div class="card-body">
                                        <div class="row">
                                            <div class="col-md-6 mb-3">
                                                <label
                                                    class="form-label">{{ __('dashboard.content_type_for_long_description') }}</label>
                                                <select class="form-control" id="aiContentType">
                                                    <option value="">{{ __('dashboard.choose_content_type') }}
                                                    </option>
                                                    <option value="detailed_description">
                                                        {{ __('dashboard.detailed_service_description') }}</option>
                                                    <option value="benefits_features">
                                                        {{ __('dashboard.service_benefits_features') }}</option>
                                                    <option value="technical_details">
                                                        {{ __('dashboard.technical_details') }}</option>
                                                    <option value="seo_content">
                                                        {{ __('dashboard.seo_optimized_content') }}</option>
                                                </select>
                                            </div>

                                            <div class="col-md-6 mb-3">
                                                <label
                                                    class="form-label">{{ __('dashboard.required_language') }}</label>
                                                <select class="form-control" id="aiLanguage">
                                                    <option value="ar">{{ __('dashboard.arabic') }}</option>
                                                    <option value="en">English</option>
                                                    <option value="both">{{ __('dashboard.both_languages') }}
                                                    </option>
                                                </select>
                                            </div>

                                            <div class="col-md-12 mb-3">
                                                <label
                                                    class="form-label">{{ __('dashboard.service_description_or_keywords') }}</label>
                                                <textarea class="form-control" id="aiPrompt" rows="3"
                                                    placeholder="{{ __('dashboard.service_description_placeholder') }}">{{ $service->name_ar ?: $service->name_en }}</textarea>
                                                <small
                                                    class="form-text text-muted">{{ __('dashboard.service_description_help_text') }}</small>
                                            </div>

                                            <div class="col-md-6 mb-3">
                                                <label class="form-label">{{ __('dashboard.content_length') }}</label>
                                                <select class="form-control" id="aiLength">
                                                    <option value="short">{{ __('dashboard.short_content') }}
                                                    </option>
                                                    <option value="medium" selected>
                                                        {{ __('dashboard.medium_content') }}</option>
                                                    <option value="long">{{ __('dashboard.long_content') }}</option>
                                                </select>
                                            </div>

                                            <div class="col-md-6 mb-3 d-flex align-items-end">
                                                <button type="button" class="btn btn-primary w-100"
                                                    id="generateServiceContent">
                                                    <i
                                                        class="fas fa-magic me-2"></i>{{ __('dashboard.generate_content') }}
                                                </button>
                                            </div>

                                            <div class="col-md-12">
                                                <div id="aiGenerationStatus" class="mt-2"></div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <!-- AI Image Generation Section -->
                            <div class="col-12">
                                <hr>
                                <h4 class="card-title">
                                    <i class="fas fa-image"></i> {{ __('dashboard.ai_image_generation') }}
                                </h4>
                                <p class="text-muted">{{ __('dashboard.ai_image_description') }}</p>

                                <div class="card border-success">
                                    <div class="card-body">
                                        <div class="row">
                                            <div class="col-md-12 mb-3">
                                                <label
                                                    class="form-label">{{ __('dashboard.image_description') }}</label>
                                                <textarea class="form-control" id="aiImagePrompt" rows="3"
                                                    placeholder="{{ __('dashboard.image_description_placeholder') }}">{{ $service->name_ar ?: $service->name_en }}</textarea>
                                                <small
                                                    class="form-text text-muted">{{ __('dashboard.image_description_help_text') }}</small>
                                            </div>

                                            <div class="col-md-6 mb-3">
                                                <label class="form-label">{{ __('dashboard.image_style') }}</label>
                                                <select class="form-control" id="aiImageStyle">
                                                    <option value="">{{ __('dashboard.choose_image_style') }}
                                                    </option>
                                                    <option value="realistic">{{ __('dashboard.realistic') }}</option>
                                                    <option value="digital-art">{{ __('dashboard.digital_art') }}
                                                    </option>
                                                    <option value="illustration">{{ __('dashboard.illustration') }}
                                                    </option>
                                                    <option value="cartoon">{{ __('dashboard.cartoon') }}</option>
                                                    <option value="photography">{{ __('dashboard.photography') }}
                                                    </option>
                                                    <option value="abstract">{{ __('dashboard.abstract') }}</option>
                                                </select>
                                            </div>

                                            <div class="col-md-6 mb-3">
                                                <label class="form-label">{{ __('dashboard.image_size') }}</label>
                                                <select class="form-control" id="aiImageSize">
                                                    <option value="512x512">{{ __('dashboard.small_512x512') }}
                                                    </option>
                                                    <option value="1024x1024" selected>
                                                        {{ __('dashboard.medium_1024x1024') }}</option>
                                                    <option value="1024x1792">{{ __('dashboard.large_1024x1792') }}
                                                    </option>
                                                </select>
                                            </div>

                                            <div class="col-md-12 mb-3 d-flex align-items-end">
                                                <button type="button" class="btn btn-success w-100"
                                                    id="generateServiceImage">
                                                    <i
                                                        class="fas fa-magic me-2"></i>{{ __('dashboard.generate_image') }}
                                                </button>
                                            </div>

                                            <div class="col-md-12">
                                                <div id="aiImageGenerationStatus" class="mt-2"></div>
                                            </div>

                                            <!-- Generated Images Display -->
                                            <div class="col-md-12 mt-3">
                                                <h5>{{ __('dashboard.generated_images') }}</h5>
                                                <div id="generatedImages" class="row">
                                                    <div class="col-12 text-center text-muted">
                                                        <p>{{ __('dashboard.no_images_generated') }}</p>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="col-12">
                                <hr>
                            </div>

                            <div class="form-group col-md-12">
                                <label for="service_images">{{ trans('dashboard.service_images') }}</label>
                                <input type="file" class="form-control" name="service_images[]" multiple
                                    accept="image/*">
                                <small class="form-text text-muted">{{ __('dashboard.max_file_size_1mb') }}</small>
                                @error('service_images')
                                    <div class="text-danger">{{ $message }}</div>
                                @enderror
                            </div>

                            @if (!empty($service->images) && $service->images->count() > 0)
                                <div class="col-12">
                                    <hr>
                                    <h5>{{ __('dashboard.current_images') }}</h5>

                                    <div class="d-flex flex-wrap mb-3 align-items-center">
                                        <button type="button" id="select_all_btn"
                                            class="btn btn-secondary me-2 mb-2">
                                            {{ trans('dashboard.select_all') }}
                                        </button>
                                        <button type="button" id="delete_selected_btn"
                                            class="btn btn-danger me-2 mb-2">
                                            {{ trans('dashboard.delete_selected') }}
                                        </button>
                                        <button type="button" data-id="{{ $service->id }}"
                                            class="delete_all_img btn btn-danger me-2 mb-2">
                                            {{ trans('dashboard.delete_all') }}
                                        </button>
                                        <button type="button" id="save_order_btn" class="btn btn-success me-2 mb-2">
                                            {{ trans('dashboard.save_order') }}
                                        </button>
                                    </div>

                                    <div class="row" id="sortable-images">
                                        @foreach ($service->images as $key => $image)
                                            <div class="col-md-3 col-sm-6 mb-3 sortable-container"
                                                data-id="{{ $image->id }}">
                                                <div class="card">
                                                    <div class="position-relative">
                                                        <div class="drag-handle">⋮⋮</div>
                                                        <img class="card-img-top" src="{{ $image->image_url }}"
                                                            style="height: 200px; object-fit: cover;">
                                                    </div>
                                                    <div class="card-body text-center">
                                                        <input type="checkbox" name="selected_images[]"
                                                            value="{{ $image->id }}"
                                                            class="select_image_checkbox mb-2">
                                                        <button type="button" data-image="{{ $image->id }}"
                                                            class="delete_img_btn btn btn-danger btn-sm">
                                                            {{ trans('dashboard.delete') }}
                                                        </button>
                                                    </div>
                                                </div>
                                            </div>
                                        @endforeach
                                    </div>
                                </div>
                            @endif

                            <div class="col-12">
                                <hr>
                            </div>

                            <div class="row mt-3">
                                <div class="form-group col-md-3">
                                    <div class="d-flex flex-wrap gap-2">
                                        <h5 class="font-size-14 mb-3">{{ __('dashboard.publish/unpublish') }}</h5>
                                        <input type="checkbox" id="switch1" switch="none" value="1"
                                            name="status" {{ old('status', $service->status) ? 'checked' : '' }} />
                                        <label for="switch1" data-on-label="{{ __('dashboard.yes') }}"
                                            data-off-label="{{ __('dashboard.no') }}"></label>
                                    </div>
                                </div>
                                <div class="form-group col-md-3">
                                    <div class="d-flex flex-wrap gap-2">
                                        <h5 class="font-size-14 mb-3">{{ __('dashboard.show_in_home') }}</h5>
                                        <input type="checkbox" id="switch2" switch="none" value="1"
                                            name="show_in_home"
                                            {{ old('show_in_home', $service->show_in_home) ? 'checked' : '' }} />
                                        <label for="switch2" data-on-label="{{ __('dashboard.yes') }}"
                                            data-off-label="{{ __('dashboard.no') }}"></label>
                                    </div>
                                </div>
                                <div class="form-group col-md-3">
                                    <div class="d-flex flex-wrap gap-2">
                                        <h5 class="font-size-14 mb-3">{{ __('dashboard.show_in_header') }}</h5>
                                        <input type="checkbox" id="switch3" switch="none" value="1"
                                            name="show_in_header"
                                            {{ old('show_in_header', $service->show_in_header) ? 'checked' : '' }} />
                                        <label for="switch3" data-on-label="{{ __('dashboard.yes') }}"
                                            data-off-label="{{ __('dashboard.no') }}"></label>
                                    </div>
                                </div>
                                <div class="form-group col-md-3">
                                    <div class="d-flex flex-wrap gap-2">
                                        <h5 class="font-size-14 mb-3">{{ __('dashboard.show_in_footer') }}</h5>
                                        <input type="checkbox" id="switch4" switch="none" value="1"
                                            name="show_in_footer"
                                            {{ old('show_in_footer', $service->show_in_footer) ? 'checked' : '' }} />
                                        <label for="switch4" data-on-label="{{ __('dashboard.yes') }}"
                                            data-off-label="{{ __('dashboard.no') }}"></label>
                                    </div>
                                </div>
                            </div>

                            <div class="col-12">
                                <hr>
                                <h4 class="card-title">{{ __('dashboard.seo') }}</h4>

                                <div class="row">
                                    <div class="form-group col-md-4">
                                        <label for="slug_en">{{ __('dashboard.slug_en') }}</label>
                                        <input type="text" autocomplete="off" class="form-control"
                                            placeholder="{{ __('dashboard.slug_en') }}" name="slug_en"
                                            value="{{ old('slug_en', $service->slug_en) }}">
                                        @error('slug_en')
                                            <div class="text-danger">{{ $message }}</div>
                                        @enderror
                                    </div>

                                    <div class="form-group col-md-4">
                                        <label>{{ __('dashboard.meta_title_en') }}</label>
                                        <textarea class="form-control" name="meta_title_en" rows="2"
                                            placeholder="{{ __('dashboard.meta_title_en') }}">{{ old('meta_title_en', $service->meta_title_en) }}</textarea>
                                    </div>

                                    <div class="form-group col-md-4">
                                        <label for="meta_desc_en">{{ __('dashboard.meta_desc_en') }}</label>
                                        <textarea class="form-control" name="meta_desc_en" rows="2"
                                            placeholder="{{ __('dashboard.meta_desc_en') }}">{{ old('meta_desc_en', $service->meta_desc_en) }}</textarea>
                                    </div>

                                    <div class="form-group col-md-4">
                                        <label>{{ __('dashboard.slug_ar') }}</label>
                                        <input type="text" autocomplete="off" class="form-control"
                                            placeholder="{{ __('dashboard.slug_ar') }}" name="slug_ar"
                                            value="{{ old('slug_ar', $service->slug_ar) }}">
                                        @error('slug_ar')
                                            <div class="text-danger">{{ $message }}</div>
                                        @enderror
                                    </div>

                                    <div class="form-group col-md-4">
                                        <label>{{ __('dashboard.meta_title_ar') }}</label>
                                        <textarea class="form-control" name="meta_title_ar" rows="2"
                                            placeholder="{{ __('dashboard.meta_title_ar') }}">{{ old('meta_title_ar', $service->meta_title_ar) }}</textarea>
                                    </div>

                                    <div class="form-group col-md-4">
                                        <label>{{ __('dashboard.meta_desc_ar') }}</label>
                                        <textarea class="form-control" name="meta_desc_ar" rows="2"
                                            placeholder="{{ __('dashboard.meta_desc_ar') }}">{{ old('meta_desc_ar', $service->meta_desc_ar) }}</textarea>
                                    </div>

                                    <div class="form-group col-md-12">
                                        <div class="d-flex flex-wrap gap-2">
                                            <h5 class="font-size-14 mb-3">{{ __('dashboard.meta_robots') }} (index)
                                            </h5>
                                            <input type="checkbox" id="switch5" switch="none" value="1"
                                                name="index"
                                                {{ old('index', $service->index) ? 'checked' : '' }} />
                                            <label for="switch5" data-on-label="{{ __('dashboard.yes') }}"
                                                data-off-label="{{ __('dashboard.no') }}"></label>
                                        </div>
                                    </div>
                                </div>
                            </div>


                            <div class="form-group col-md-12">
                                <button type="submit" class="btn btn-success">
                                    <i class="icon-note"></i> {{ __('dashboard.update') }}
                                </button>
                                <a href="{{ route('dashboard.services.index') }}" class="btn btn-danger ms-2">
                                    <i class="icon-trash"></i> {{ __('dashboard.cancel') }}
                                </a>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
    <!-- End Row -->

    @section('script')
        <!-- Rich Text Editor (TinyMCE 6 - Latest Version) -->
        <script src="https://cdn.jsdelivr.net/npm/sortablejs@1.15.0/Sortable.min.js"></script>
        <script src="https://cdnjs.cloudflare.com/ajax/libs/dropzone/4.0.1/dropzone.js"></script>


        {{-- في نهاية ملف blade الخاص بك، استبدل كل الـ JavaScript بهذا: --}}

        {{-- إعداد المتغيرات العامة --}}
        <script type="text/javascript">
            // إعداد البيانات الأساسية
            window.serviceId = "{{ $service->id ?? '' }}";
            window.routes = {
                uploadImages: "{{ route('dashboard.dashboard.services.uploadImages') }}",
                deleteSelectedImages: "{{ route('dashboard.dashboard.services.deleteSelectedImages') }}",
                deleteAllImages: "{{ route('dashboard.dashboard.services.deleteAllImages') }}",
                deleteImage: "{{ route('dashboard.dashboard.services.deleteImage') }}",
                reorderImages: "{{ route('dashboard.dashboard.services.reorderImages') }}",
                removeUploadImages: "{{ route('dashboard.dashboard.services.removeUploadImages') }}",
                generateAI: "{{ route('dashboard.ai-content.generate') }}",
                saveImageToService: "{{ route('dashboard.ai-content.save-image-to-service') }}"
            };

            // ترجمات للاستخدام في JavaScript
            window.translations = {
                select_all: "{{ __('dashboard.select_all') }}",
                unselect_all: "{{ __('dashboard.unselect_all') }}",
                please_select_images_to_delete: "{{ __('dashboard.please_select_images_to_delete') }}",
                confirm_delete_selected_images: "{{ __('dashboard.confirm_delete_selected_images') }}",
                confirm_delete_all_images: "{{ __('dashboard.confirm_delete_all_images') }}",
                confirm_delete_this_image: "{{ __('dashboard.confirm_delete_this_image') }}",
                order_changed: "{{ __('dashboard.order_changed') }}",
                no_images_to_save_order: "{{ __('dashboard.no_images_to_save_order') }}",
                order_saved_successfully: "{{ __('dashboard.order_saved_successfully') }}",
                error_saving_order: "{{ __('dashboard.error_saving_order') }}",
                error_occurred_during_deletion: "{{ __('dashboard.error_occurred_during_deletion') }}",
                max_image_size_1mb: "{{ __('dashboard.max_image_size_1mb') }}",
                please_choose_content_type: "{{ __('dashboard.please_choose_content_type') }}",
                please_enter_service_description: "{{ __('dashboard.please_enter_service_description') }}",
                generating: "{{ __('dashboard.generating') }}",
                generating_content: "{{ __('dashboard.generating_content') }}",
                content_generated_successfully: "{{ __('dashboard.content_generated_successfully') }}",
                failed_to_generate_content: "{{ __('dashboard.failed_to_generate_content') }}",
                content_generation_error: "{{ __('dashboard.content_generation_error') }}",
                session_expired_reload_page: "{{ __('dashboard.session_expired_reload_page') }}",
                server_error: "{{ __('dashboard.server_error') }}",
                service_not_available: "{{ __('dashboard.service_not_available') }}",
                please_enter_image_description: "{{ __('dashboard.please_enter_image_description') }}",
                please_choose_image_style: "{{ __('dashboard.please_choose_image_style') }}",
                generating_image: "{{ __('dashboard.generating_image') }}",
                image_generated_successfully: "{{ __('dashboard.image_generated_successfully') }}",
                failed_to_generate_image: "{{ __('dashboard.failed_to_generate_image') }}",
                image_generation_error: "{{ __('dashboard.image_generation_error') }}",
                download_image: "{{ __('dashboard.download_image') }}",
                use_as_service_image: "{{ __('dashboard.use_as_service_image') }}",
                use_as_service_icon: "{{ __('dashboard.use_as_service_icon') }}",
                saving: "{{ __('dashboard.saving') }}",
                saved: "{{ __('dashboard.saved') }}",
                save_failed: "{{ __('dashboard.save_failed') }}",
                error_during_save: "{{ __('dashboard.error_during_save') }}",
                success: "{{ __('dashboard.success') }}",
                page_reload_to_show_updates: "{{ __('dashboard.page_reload_to_show_updates') }}",
                page_will_reload: "{{ __('dashboard.page_will_reload') }}",
                reloading: "{{ __('dashboard.reloading') }}"
            };

            // إعداد CSRF token
            window.csrfToken = "{{ csrf_token() }}";

            // تفعيل وضع التشخيص إذا كان في URL
            window.debugMode = new URLSearchParams(window.location.search).has('debug');
        </script>

        {{-- تحميل ملفات JavaScript المنظمة --}}
        <!-- Setup global variables -->
        <script type="text/javascript">
            // Setup global variables for JavaScript files
            window.routes = {
                generateAI: "{{ route('dashboard.ai-content.generate') }}"
            };
            window.csrfToken = "{{ csrf_token() }}";
        </script>

        <!-- Service AI Content JavaScript - Inline Version -->
        <script>
            $(document).ready(function() {
                console.log('🔧 Loading inline AI content script for services...');

                // AI Content Generation for Services
                $('#generateServiceContent').on('click', function(e) {
                    e.preventDefault();

                    var contentType = $('#aiContentType').val();
                    var prompt = $('#aiPrompt').val().trim();
                    var language = $('#aiLanguage').val();
                    var length = $('#aiLength').val();

                    console.log('🚀 === AI SERVICE CONTENT GENERATION STARTED ===');
                    console.log('📋 Form values:', {
                        contentType,
                        prompt,
                        language,
                        length
                    });
                    console.log('🌍 Selected language:', language);

                    // Auto-fill prompt from service names if empty
                    if (!prompt) {
                        var nameEn = $('input[name="name_en"]').val();
                        var nameAr = $('input[name="name_ar"]').val();
                        if (nameAr) {
                            prompt = nameAr;
                            $('#aiPrompt').val(prompt);
                        } else if (nameEn) {
                            prompt = nameEn;
                            $('#aiPrompt').val(prompt);
                        }
                    }

                    if (!contentType) {
                        alert('يرجى اختيار نوع المحتوى');
                        return;
                    }
                    if (!prompt) {
                        alert('يرجى إدخال وصف الخدمة أو اسم الخدمة أولاً');
                        return;
                    }

                    var $btn = $(this);
                    var originalText = $btn.html();
                    $btn.prop('disabled', true).html(
                        '<i class="fas fa-spinner fa-spin me-2"></i>جاري التوليد...');
                    $('.card').addClass('ai-loading');

                    var fullPrompt = createServiceAIPrompt(contentType, prompt, language, length);
                    showStatus('جاري توليد المحتوى...', 'info');

                    $.ajax({
                        url: window.routes?.generateAI || '/dashboard/ai-content/generate',
                        method: 'POST',
                        headers: {
                            'Content-Type': 'application/json',
                            'Accept': 'application/json',
                            'X-CSRF-TOKEN': window.csrfToken || $('meta[name="csrf-token"]').attr(
                                'content')
                        },
                        data: JSON.stringify({
                            type: 'service_content',
                            prompt: fullPrompt,
                            content_type: contentType,
                            language: language,
                            length: length,
                            options: {
                                max_tokens: getTokensByLength(length),
                                temperature: 0.7
                            }
                        }),
                        success: function(response) {
                            console.log('AI Response:', response);
                            if (response.success && response.content) {
                                var content = response.content.content || response.content;
                                console.log('Generated content preview:', content.substring(0,
                                    300) + '...');
                                applyGeneratedContent(content, language, contentType);
                                showStatus('تم توليد المحتوى بنجاح!', 'success');
                            } else {
                                showStatus(response.error || response.message ||
                                    'فشل في توليد المحتوى', 'danger');
                            }
                        },
                        error: function(xhr, status, error) {
                            console.error('AI Generation Error:', {
                                xhr,
                                status,
                                error
                            });
                            var errorMsg = 'حدث خطأ في توليد المحتوى';
                            if (xhr.status === 419) errorMsg =
                                'انتهت صلاحية الصفحة، يرجى إعادة تحميل الصفحة';
                            else if (xhr.status === 500) errorMsg = 'خطأ في الخادم';
                            else if (xhr.status === 404) errorMsg = 'الخدمة غير متوفرة حالياً';
                            else if (xhr.responseJSON && xhr.responseJSON.message) errorMsg = xhr
                                .responseJSON.message;
                            showStatus(errorMsg, 'danger');
                        },
                        complete: function() {
                            $btn.prop('disabled', false).html(originalText);
                            $('.card').removeClass('ai-loading');
                        }
                    });
                });

                // Helper functions
                function createServiceAIPrompt(contentType, prompt, language, length) {
                    var languageInstruction = '';
                    if (language === 'ar') languageInstruction = 'اكتب النص باللغة العربية فقط.';
                    else if (language === 'en') languageInstruction = 'Write the text in English only.';
                    else languageInstruction = 'اكتب النص باللغة العربية أولاً، ثم بالإنجليزية.';

                    var basePrompt = '';
                    switch (contentType) {
                        case 'detailed_description':
                            basePrompt = 'اكتب وصف تفصيلي ومفصل لخدمة: ' + prompt +
                                '. يجب أن يكون الوصف جذاب ومفيد للعملاء المحتملين، يشرح طبيعة الخدمة وفوائدها.';
                            break;
                        case 'benefits_features':
                            basePrompt = 'اكتب عن فوائد ومميزات خدمة: ' + prompt +
                                '. ركز على القيمة المضافة والمزايا التنافسية التي تقدمها هذه الخدمة للعملاء.';
                            break;
                        case 'technical_details':
                            basePrompt = 'اكتب التفاصيل التقنية والمواصفات لخدمة: ' + prompt +
                                '. يجب أن يكون النص دقيق ومفصل تقنياً ومفهوم للمختصين.';
                            break;
                        case 'seo_content':
                            basePrompt = 'اكتب محتوى محسن لمحركات البحث عن خدمة: ' + prompt +
                                '. استخدم الكلمات المفتاحية بشكل طبيعي ومفيد للعملاء.';
                            break;
                        default:
                            basePrompt = 'اكتب وصف شامل عن خدمة: ' + prompt + '.';
                    }
                    return basePrompt + ' ' + languageInstruction;
                }

                function getTokensByLength(length) {
                    switch (length) {
                        case 'short':
                            return 300; // زيادة من 150 إلى 300 (حوالي 200-250 كلمة)
                        case 'medium':
                            return 800; // زيادة من 400 إلى 800 (حوالي 500-600 كلمة)
                        case 'long':
                            return 1500; // زيادة من 600 إلى 1500 (حوالي 1000-1200 كلمة)
                        default:
                            return 800;
                    }
                }

                function applyGeneratedContent(content, language, contentType) {
                    console.log('🎯 === APPLYING CONTENT TO ' + language.toUpperCase() + ' FIELD ===');
                    console.log('🌍 Target language:', language);
                    console.log('📝 Target field should be: long_desc_' + language);

                    var formattedContent = formatContentForEditor(content);
                    console.log('📄 Formatted content preview:', formattedContent.substring(0, 200) + '...');

                    applyToFields(formattedContent, language, contentType);
                }

                function formatContentForEditor(content) {
                    if (!content) return content;

                    console.log('📝 Formatting content for better display...');

                    // تنظيف المحتوى من الفراغات الزائدة
                    content = content.trim();

                    // تحويل النقاط والقوائم إلى HTML منسق
                    content = content.replace(/^\s*[\-\*\+]\s+/gm, '<li>');
                    content = content.replace(/^\s*\d+\.\s+/gm, '<li>');

                    // تحويل الفقرات المنفصلة
                    content = content.replace(/\n\n+/g, '</p>\n<p>');
                    content = content.replace(/\n/g, '<br>\n');

                    // إضافة تنسيق للعناوين (إذا وُجدت)
                    content = content.replace(/^(.+):$/gm, '<strong>$1:</strong>');

                    // تنسيق الكلمات المهمة
                    content = content.replace(/\*\*([^*]+)\*\*/g, '<strong>$1</strong>');
                    content = content.replace(/\*([^*]+)\*/g, '<em>$1</em>');

                    // إضافة فقرات HTML
                    if (!content.startsWith('<p>')) {
                        content = '<p>' + content;
                    }
                    if (!content.endsWith('</p>')) {
                        content = content + '</p>';
                    }

                    // تنظيف القوائم إذا وُجدت
                    if (content.includes('<li>')) {
                        content = content.replace(/(<li>[^<]*(?:<[^>]*>[^<]*)*)/g, '<ul>$1</ul>');
                        content = content.replace(/<\/ul>\s*<ul>/g, '');
                    }

                    // إضافة مسافات بين الفقرات
                    content = content.replace(/<\/p>\s*<p>/g, '</p>\n\n<p>');

                    console.log('✅ Content formatted successfully');
                    return content;
                }

                function applyToFields(content, lang, contentType) {
                    const fieldName = 'long_desc_' + lang;
                    console.log('🎯 Applying content to field:', fieldName);

                    // Clear other language field first
                    if (lang === 'ar') {
                        $('textarea[name="long_desc_en"]').val('');
                        console.log('🧹 Cleared English field');
                    } else if (lang === 'en') {
                        $('textarea[name="long_desc_ar"]').val('');
                        console.log('🧹 Cleared Arabic field');
                    }

                    // Update textarea directly
                    const $textarea = $('textarea[name="' + fieldName + '"]');
                    if ($textarea.length > 0) {
                        $textarea.val('').val(content);
                        $textarea.trigger('input').trigger('change');
                        console.log('✅ Content applied to textarea ' + fieldName);

                        // Update TinyMCE if available
                        if (typeof tinymce !== 'undefined') {
                            const textareaId = $textarea.attr('id');
                            if (textareaId) {
                                const editor = tinymce.get(textareaId);
                                if (editor) {
                                    editor.setContent('');
                                    editor.setContent(content);
                                    console.log('🎨 ✅ Updated TinyMCE editor for ' + fieldName);
                                }
                            }
                        }

                        // Final verification
                        setTimeout(function() {
                            console.log('🔍 Final verification: ' + fieldName + ' content length: ' + $textarea
                                .val().length);
                        }, 1000);
                    } else {
                        console.error('❌ Textarea ' + fieldName + ' not found!');
                    }
                }

                function showStatus(message, type) {
                    var alertClass = {
                        'success': 'alert-success',
                        'danger': 'alert-danger',
                        'warning': 'alert-warning',
                        'info': 'alert-info'
                    };

                    $('#aiGenerationStatus').html(
                        '<div class="alert ' + alertClass[type] + ' alert-dismissible fade show" role="alert">' +
                        message +
                        '<button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>' +
                        '</div>'
                    );

                    if (type === 'success') {
                        setTimeout(function() {
                            $('#aiGenerationStatus').fadeOut();
                        }, 5000);
                    }
                }

                console.log('✅ Service AI Content script loaded inline successfully');
            });
        </script>

        <!-- TinyMCE Editor Component -->
        <x-dashboard.tinymce-config />

        {{-- CSS إضافي للتحسينات --}}
        <!-- <style>
                                                    /* تحسينات بصرية للتطبيق */
                                                    .ai-loading {
                                                        position: relative;
                                                        pointer-events: none;
                                                    }

                                                    .ai-loading::before {
                                                        content: '';
                                                        position: absolute;
                                                        top: 0;
                                                        left: 0;
                                                        right: 0;
                                                        bottom: 0;
                                                        background: rgba(255, 255, 255, 0.8);
                                                        z-index: 1000;
                                                        border-radius: 0.375rem;
                                                    }

                                                    .ai-loading::after {
                                                        content: '';
                                                        position: absolute;
                                                        top: 50%;
                                                        left: 50%;
                                                        width: 2rem;
                                                        height: 2rem;
                                                        margin: -1rem 0 0 -1rem;
                                                        border: 3px solid #f3f3f3;
                                                        border-top: 3px solid #007bff;
                                                        border-radius: 50%;
                                                        animation: spin 1s linear infinite;
                                                        z-index: 1001;
                                                    }

                                                    @keyframes spin {
                                                        0% {
                                                            transform: rotate(0deg);
                                                        }

                                                        100% {
                                                            transform: rotate(360deg);
                                                        }
                                                    }

                                                    /* تحسينات للأزرار */
                                                    .btn-group .btn {
                                                        transition: all 0.2s ease-in-out;
                                                    }

                                                    .btn-group .btn:hover {
                                                        transform: translateY(-1px);
                                                        box-shadow: 0 2px 4px rgba(0, 0, 0, 0.1);
                                                    }

                                                    /* تحسينات للتنبيهات */
                                                    .alert {
                                                        border: none;
                                                        border-radius: 0.5rem;
                                                        box-shadow: 0 2px 4px rgba(0, 0, 0, 0.1);
                                                    }

                                                    .position-fixed.alert {
                                                        animation: slideInRight 0.3s ease-out;
                                                    }

                                                    @keyframes slideInRight {
                                                        from {
                                                            transform: translateX(100%);
                                                            opacity: 0;
                                                        }

                                                        to {
                                                            transform: translateX(0);
                                                            opacity: 1;
                                                        }
                                                    }

                                                    /* تحسينات للسحب والإفلات */
                                                    .sortable-ghost {
                                                        opacity: 0.5;
                                                        background: #f8f9fa;
                                                        border: 2px dashed #dee2e6;
                                                    }

                                                    .sortable-chosen {
                                                        cursor: grabbing;
                                                    }

                                                    .drag-handle {
                                                        cursor: grab;
                                                        color: #6c757d;
                                                        transition: color 0.2s;
                                                    }

                                                    .drag-handle:hover {
                                                        color: #495057;
                                                    }

                                                    /* تحسينات TinyMCE */
                                                    .tox-tinymce {
                                                        border-radius: 0.375rem !important;
                                                        border-color: #ced4da !important;
                                                    }

                                                    .tox-toolbar__primary {
                                                        background: #f8f9fa !important;
                                                    }

                                                    /* تحسينات للصور المولدة */
                                                    .generated-image-card {
                                                        transition: transform 0.2s ease-in-out;
                                                        border: 1px solid #dee2e6;
                                                    }

                                                    .generated-image-card:hover {
                                                        transform: translateY(-2px);
                                                        box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);
                                                    }

                                                    .generated-image-card img {
                                                        transition: transform 0.2s ease-in-out;
                                                    }

                                                    .generated-image-card:hover img {
                                                        transform: scale(1.02);
                                                    }

                                                    /* تحسينات للأزرار التفاعلية */
                                                    .use-as-image {
                                                        position: relative;
                                                        overflow: hidden;
                                                    }

                                                    .use-as-image::before {
                                                        content: '';
                                                        position: absolute;
                                                        top: 0;
                                                        left: -100%;
                                                        width: 100%;
                                                        height: 100%;
                                                        background: linear-gradient(90deg, transparent, rgba(255, 255, 255, 0.2), transparent);
                                                        transition: left 0.5s;
                                                    }

                                                    .use-as-image:hover::before {
                                                        left: 100%;
                                                    }

                                                    /* تحسينات للحقول */
                                                    .form-control:focus,
                                                    .form-select:focus {
                                                        border-color: #86b7fe;
                                                        box-shadow: 0 0 0 0.25rem rgba(13, 110, 253, 0.25);
                                                    }

                                                    /* تحسينات للمتبات */
                                                    .nav-tabs .nav-link {
                                                        border-radius: 0.375rem 0.375rem 0 0;
                                                        transition: all 0.2s ease-in-out;
                                                    }

                                                    .nav-tabs .nav-link:hover {
                                                        border-color: #e9ecef #e9ecef #dee2e6;
                                                        transform: translateY(-1px);
                                                    }

                                                    .nav-tabs .nav-link.active {
                                                        background-color: #fff;
                                                        border-color: #dee2e6 #dee2e6 #fff;
                                                        font-weight: 500;
                                                    }

                                                    /* تحسينات للبطاقات */
                                                    .card {
                                                        border: 1px solid #dee2e6;
                                                        border-radius: 0.5rem;
                                                        transition: box-shadow 0.2s ease-in-out;
                                                    }

                                                    .card:hover {
                                                        box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);
                                                    }

                                                    .card-header {
                                                        background-color: #f8f9fa;
                                                        border-bottom: 1px solid #dee2e6;
                                                        font-weight: 500;
                                                    }

                                                    /* تحسينات للشبكة */
                                                    .row>[class*="col-"] {
                                                        margin-bottom: 1rem;
                                                    }

                                                    /* تحسينات للنماذج */
                                                    .form-label {
                                                        font-weight: 500;
                                                        margin-bottom: 0.5rem;
                                                    }

                                                    .form-text {
                                                        font-size: 0.875rem;
                                                        color: #6c757d;
                                                    }

                                                    /* تحسينات للتحميل */
                                                    .upload-area {
                                                        border: 2px dashed #ced4da;
                                                        border-radius: 0.5rem;
                                                        padding: 2rem;
                                                        text-align: center;
                                                        transition: all 0.2s ease-in-out;
                                                        background-color: #f8f9fa;
                                                    }

                                                    .upload-area:hover {
                                                        border-color: #007bff;
                                                        background-color: #e7f1ff;
                                                    }

                                                    .upload-area.dragover {
                                                        border-color: #0056b3;
                                                        background-color: #cce5ff;
                                                    }

                                                    /* تحسينات للتقدم */
                                                    .progress {
                                                        height: 0.5rem;
                                                        border-radius: 0.25rem;
                                                        background-color: #e9ecef;
                                                    }

                                                    .progress-bar {
                                                        transition: width 0.6s ease;
                                                    }

                                                    /* تحسينات للأيقونات */
                                                    .fas,
                                                    .far,
                                                    .fab {
                                                        transition: transform 0.2s ease-in-out;
                                                    }

                                                    .btn:hover .fas,
                                                    .btn:hover .far,
                                                    .btn:hover .fab {
                                                        transform: scale(1.1);
                                                    }

                                                    /* تحسينات للشاشات الصغيرة */
                                                    @media (max-width: 768px) {
                                                        .position-fixed.alert {
                                                            left: 1rem;
                                                            right: 1rem;
                                                            max-width: none;
                                                        }

                                                        .btn-group {
                                                            flex-direction: column;
                                                        }

                                                        .btn-group .btn {
                                                            border-radius: 0.375rem !important;
                                                            margin-bottom: 0.25rem;
                                                        }

                                                        .card-body {
                                                            padding: 1rem;
                                                        }
                                                    }

                                                    /* تحسينات للطباعة */
                                                    @media print {

                                                        .btn,
                                                        .alert,
                                                        .modal,
                                                        .position-fixed {
                                                            display: none !important;
                                                        }

                                                        .card {
                                                            border: 1px solid #000 !important;
                                                            box-shadow: none !important;
                                                        }
                                                    }

                                                    /* تحسينات للوضع المظلم (إذا كان مدعوماً) */
                                                    @media (prefers-color-scheme: dark) {
                                                        .card {
                                                            background-color: #2d3748;
                                                            border-color: #4a5568;
                                                            color: #e2e8f0;
                                                        }

                                                        .card-header {
                                                            background-color: #1a202c;
                                                            border-color: #4a5568;
                                                        }

                                                        .form-control,
                                                        .form-select {
                                                            background-color: #2d3748;
                                                            border-color: #4a5568;
                                                            color: #e2e8f0;
                                                        }

                                                        .form-control:focus,
                                                        .form-select:focus {
                                                            background-color: #2d3748;
                                                            border-color: #63b3ed;
                                                            color: #e2e8f0;
                                                        }
                                                    }
                                                </style> -->

        {{-- JavaScript للتوافق مع الكود القديم --}}
        <script>
            // دوال للتوافق مع الكود القديم
            window.addEventListener('DOMContentLoaded', function() {
                // إضافة دوال عامة للاستخدام في أماكن أخرى
                window.showNotification = function(message, type = 'info') {
                    if (window.serviceApp) {
                        return window.serviceApp.showGlobalAlert(message, type);
                    } else {
                        alert(message);
                    }
                };

                window.confirmAction = function(message, callback) {
                    if (confirm(message)) {
                        if (typeof callback === 'function') {
                            callback();
                        }
                    }
                };

                // إضافة وظائف مساعدة للنماذج
                window.validateForm = function(formSelector) {
                    const form = document.querySelector(formSelector);
                    if (!form) return false;

                    return form.checkValidity();
                };

                window.resetForm = function(formSelector) {
                    const form = document.querySelector(formSelector);
                    if (form) {
                        form.reset();
                        // إعادة تعيين محررات TinyMCE
                        if (typeof tinymce !== 'undefined') {
                            tinymce.editors.forEach(editor => {
                                editor.setContent('');
                            });
                        }
                    }
                };

                // إضافة وظائف للتعامل مع الملفات
                window.previewImage = function(input, previewId) {
                    if (input.files && input.files[0]) {
                        const reader = new FileReader();
                        reader.onload = function(e) {
                            document.getElementById(previewId).src = e.target.result;
                        };
                        reader.readAsDataURL(input.files[0]);
                    }
                };

                // إضافة وظائف للتعامل مع الجدولة
                window.scheduleAction = function(action, delay = 1000) {
                    setTimeout(action, delay);
                };

                // إضافة دعم للاختصارات
                document.addEventListener('keydown', function(e) {
                    // Alt + H: إظهار المساعدة
                    if (e.altKey && e.key === 'h') {
                        e.preventDefault();
                        showKeyboardShortcuts();
                    }
                });

                function showKeyboardShortcuts() {
                    const shortcuts = `
            <div class="modal fade" id="shortcutsModal" tabindex="-1">
                <div class="modal-dialog">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h5 class="modal-title">اختصارات لوحة المفاتيح</h5>
                            <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                        </div>
                        <div class="modal-body">
                            <div class="row">
                                <div class="col-md-6">
                                    <h6>الاختصارات العامة:</h6>
                                    <ul class="list-unstyled">
                                        <li><kbd>Ctrl</kbd> + <kbd>S</kbd> - حفظ النموذج</li>
                                        <li><kbd>Ctrl</kbd> + <kbd>G</kbd> - توليد محتوى AI</li>
                                        <li><kbd>Ctrl</kbd> + <kbd>I</kbd> - توليد صورة AI</li>
                                        <li><kbd>Esc</kbd> - إغلاق النوافذ المنبثقة</li>
                                    </ul>
                                </div>
                                <div class="col-md-6">
                                    <h6>المساعدة:</h6>
                                    <ul class="list-unstyled">
                                        <li><kbd>Alt</kbd> + <kbd>H</kbd> - إظهار هذه النافذة</li>
                                        <li><kbd>F5</kbd> - إعادة تحميل الصفحة</li>
                                    </ul>
                                </div>
                            </div>
                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">إغلاق</button>
                        </div>
                    </div>
                </div>
            </div>
        `;

                    // إضافة النافذة إذا لم تكن موجودة
                    if (!document.getElementById('shortcutsModal')) {
                        document.body.insertAdjacentHTML('beforeend', shortcuts);
                    }

                    // إظهار النافذة
                    const modal = new bootstrap.Modal(document.getElementById('shortcutsModal'));
                    modal.show();
                }

                // تسجيل أن التطبيق جاهز
                console.log('🚀 تم تحميل جميع ملفات JavaScript بنجاح');

                // إشعار المطور
                if (window.debugMode) {
                    console.log('🔧 وضع التطوير مفعل - استخدم window.devHelpers للأدوات');
                }
            });
        </script>
    @endsection

</x-dashboard.layout>
