<x-dashboard.layout :title="__('dashboard.add_service')">

    @section('style')
        <style>
            .ai-loading {
                opacity: 0.6;
                pointer-events: none;
            }

            .form-group {
                margin-bottom: 1rem;
            }

            .card-body {
                padding: 1.5rem;
            }

            .alert {
                margin-top: 0.5rem;
            }
        </style>
    @endsection

    <!-- Page Header -->
    <x-dashboard.partials.page-header :header="__('dashboard.add_service')" :label_url="route('dashboard.services.index')" :label="__('dashboard.services')" />
    <!-- End Page Header -->

    <!-- Row-->
    <div class="row">
        <div class="col-sm-12 col-xl-12 col-lg-12">
            <div class="card custom-card overflow-hidden">
                <div class="card-header">
                    <h4 class="card-title">{{ __('dashboard.add_service') }}</h4>
                </div>

                <div class="card-body">
                    <form action="{{ route('dashboard.services.store') }}" method="POST" enctype="multipart/form-data">
                        @csrf
                        <div class="row">

                            <div class="form-group col-md-5">
                                <label class="">{{ __('dashboard.name_en') }}</label>
                                <input class="form-control" name="name_en" type="text" value="{{ old('name_en') }}"
                                    placeholder="{{ __('dashboard.name_en') }}">
                                @error('name_en')
                                    <div class="text-danger">{{ $message }}</div>
                                @enderror
                            </div>

                            <div class="form-group col-md-5">
                                <label class="">{{ __('dashboard.name_ar') }}</label>
                                <input class="form-control" name="name_ar" type="text" value="{{ old('name_ar') }}"
                                    placeholder="{{ __('dashboard.name_ar') }}">
                                @error('name_ar')
                                    <div class="text-danger">{{ $message }}</div>
                                @enderror
                            </div>

                            <div class="form-group col-md-1">
                                <label>{{ __('dashboard.order') }}</label>
                                <input class="form-control" name="order" type="number" value="{{ old('order') }}"
                                    placeholder="{{ __('dashboard.order') }}">
                                @error('order')
                                    <div class="text-danger">{{ $message }}</div>
                                @enderror
                            </div>

                            <div class="form-group col-md-1">
                                <label for="parent">{{ __('dashboard.parent') }}</label>
                                <select class="form-control select2" name="parent_id">
                                    <option value="" {{ !old('parent_id') ? 'selected' : '' }}>
                                        {{ __('dashboard.no_parent') }}
                                    </option>
                                    @foreach ($services as $serviceItem)
                                        <option value="{{ $serviceItem->id }}"
                                            {{ old('parent_id') == $serviceItem->id ? 'selected' : '' }}>
                                            {{ $serviceItem->name }}
                                        </option>
                                    @endforeach
                                </select>
                                @error('parent_id')
                                    <div class="text-danger">{{ $message }}</div>
                                @enderror
                            </div>

                            <div class="col-12">
                                <hr>
                            </div>

                            <div class="form-group col-md-8">
                                <label>{{ __('dashboard.image') }} (225px * 225px max 1mb)</label>
                                <input type="file" class="form-control" name="image" accept="image/*">
                                @error('image')
                                    <div class="text-danger">{{ $message }}</div>
                                @enderror
                            </div>

                            <div class="form-group col-md-4">
                                <label class="">{{ __('dashboard.alt_image') }}</label>
                                <input class="form-control" name="alt_image" type="text"
                                    value="{{ old('alt_image') }}" placeholder="{{ __('dashboard.alt_image') }}">
                            </div>

                            <div class="form-group col-md-8">
                                <label>{{ __('dashboard.icon') }} (50px * 50px max 1mb)</label>
                                <input type="file" class="form-control" name="icon" accept="image/*">
                                @error('icon')
                                    <div class="text-danger">{{ $message }}</div>
                                @enderror
                            </div>

                            <div class="form-group col-md-4">
                                <label class="">{{ __('dashboard.alt_icon') }}</label>
                                <input class="form-control" name="alt_icon" type="text"
                                    value="{{ old('alt_icon') }}" placeholder="{{ __('dashboard.alt_icon') }}">
                            </div>

                            <div class="col-12">
                                <hr>
                            </div>

                            <div class="form-group col-md-6">
                                <label class="">{{ __('dashboard.short_desc_en') }}</label>
                                <textarea class="form-control" name="short_desc_en" rows="3" placeholder="{{ __('dashboard.short_desc_en') }}">{{ old('short_desc_en') }}</textarea>
                                @error('short_desc_en')
                                    <div class="text-danger">{{ $message }}</div>
                                @enderror
                            </div>

                            <div class="form-group col-md-6">
                                <label class="">{{ __('dashboard.short_desc_ar') }}</label>
                                <textarea class="form-control" name="short_desc_ar" rows="3" placeholder="{{ __('dashboard.short_desc_ar') }}">{{ old('short_desc_ar') }}</textarea>
                                @error('short_desc_ar')
                                    <div class="text-danger">{{ $message }}</div>
                                @enderror
                            </div>

                            <div class="form-group col-md-6">
                                <label class="">{{ __('dashboard.long_desc_en') }}</label>
                                <textarea class="form-control editor-textarea" id="long_desc_en" name="long_desc_en" rows="6"
                                    placeholder="{{ __('dashboard.long_desc_en') }}">{{ old('long_desc_en') }}</textarea>
                                @error('long_desc_en')
                                    <div class="text-danger">{{ $message }}</div>
                                @enderror
                            </div>

                            <div class="form-group col-md-6">
                                <label class="">{{ __('dashboard.long_desc_ar') }}</label>
                                <textarea class="form-control editor-textarea" id="long_desc_ar" name="long_desc_ar" rows="6"
                                    placeholder="{{ __('dashboard.long_desc_ar') }}">{{ old('long_desc_ar') }}</textarea>
                                @error('long_desc_ar')
                                    <div class="text-danger">{{ $message }}</div>
                                @enderror
                            </div>

                            <!-- AI Content Generation Section -->
                            <div class="col-12">
                                <hr>
                                <h4 class="card-title">
                                    <i class="fas fa-robot"></i> توليد المحتوى بواسطة AI
                                </h4>
                                <p class="text-muted">يمكنك استخدام الذكاء الاصطناعي لتوليد محتوى للخدمة</p>

                                <div class="card border-primary">
                                    <div class="card-body">
                                        <div class="row">
                                            <div class="col-md-6 mb-3">
                                                <label class="form-label">نوع المحتوى للوصف الطويل</label>
                                                <select class="form-control" id="aiContentType">
                                                    <option value="">اختر نوع المحتوى</option>
                                                    <option value="detailed_description">وصف تفصيلي للخدمة</option>
                                                    <option value="benefits_features">فوائد ومميزات الخدمة</option>
                                                    <option value="technical_details">التفاصيل التقنية</option>
                                                    <option value="seo_content">محتوى محسن لمحركات البحث</option>
                                                </select>
                                            </div>

                                            <div class="col-md-6 mb-3">
                                                <label class="form-label">اللغة المطلوبة</label>
                                                <select class="form-control" id="aiLanguage">
                                                    <option value="ar">العربية</option>
                                                    <option value="en">English</option>
                                                    <option value="both">كلا اللغتين</option>
                                                </select>
                                            </div>

                                            <div class="col-md-12 mb-3">
                                                <label class="form-label">وصف الخدمة أو الكلمات المفتاحية</label>
                                                <textarea class="form-control" id="aiPrompt" rows="3"
                                                    placeholder="مثال: خدمة تصميم المواقع الإلكترونية، تطوير تطبيقات الجوال، استضافة المواقع..."></textarea>
                                                <small class="form-text text-muted">اكتب وصف مختصر عن الخدمة أو الكلمات
                                                    المفتاحية المطلوبة</small>
                                            </div>

                                            <div class="col-md-6 mb-3">
                                                <label class="form-label">طول المحتوى</label>
                                                <select class="form-control" id="aiLength">
                                                    <option value="short">قصير (200-300 كلمة)</option>
                                                    <option value="medium" selected>متوسط (500-700 كلمة)</option>
                                                    <option value="long">طويل (1000-1500 كلمة)</option>
                                                </select>
                                            </div>

                                            <div class="col-md-6 mb-3 d-flex align-items-end">
                                                <button type="button" class="btn btn-primary w-100"
                                                    id="generateServiceContent">
                                                    <i class="fas fa-magic me-2"></i>توليد المحتوى
                                                </button>
                                            </div>

                                            <div class="col-md-12">
                                                <div id="aiGenerationStatus" class="mt-2"></div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="col-12">
                                <hr>
                            </div>

                            <div class="row mt-3">
                                <div class="form-group col-md-3">
                                    <div class="d-flex flex-wrap gap-2">
                                        <h5 class="font-size-14 mb-3">{{ __('dashboard.publish/unpublish') }}</h5>
                                        <input type="checkbox" id="switch1" switch="none" value="1"
                                            name="status" {{ old('status', true) ? 'checked' : '' }} />
                                        <label for="switch1" data-on-label="{{ __('dashboard.yes') }}"
                                            data-off-label="{{ __('dashboard.no') }}"></label>
                                    </div>
                                </div>

                                <div class="form-group col-md-3">
                                    <div class="d-flex flex-wrap gap-2">
                                        <h5 class="font-size-14 mb-3">{{ __('dashboard.show_in_home') }}</h5>
                                        <input type="checkbox" id="switch2" switch="none" value="1"
                                            name="show_in_home" {{ old('show_in_home', true) ? 'checked' : '' }} />
                                        <label for="switch2" data-on-label="{{ __('dashboard.yes') }}"
                                            data-off-label="{{ __('dashboard.no') }}"></label>
                                    </div>
                                </div>

                                <div class="form-group col-md-3">
                                    <div class="d-flex flex-wrap gap-2">
                                        <h5 class="font-size-14 mb-3">{{ __('dashboard.show_in_header') }}</h5>
                                        <input type="checkbox" id="switch3" switch="none" value="1"
                                            name="show_in_header"
                                            {{ old('show_in_header', true) ? 'checked' : '' }} />
                                        <label for="switch3" data-on-label="{{ __('dashboard.yes') }}"
                                            data-off-label="{{ __('dashboard.no') }}"></label>
                                    </div>
                                </div>

                                <div class="form-group col-md-3">
                                    <div class="d-flex flex-wrap gap-2">
                                        <h5 class="font-size-14 mb-3">{{ __('dashboard.show_in_footer') }}</h5>
                                        <input type="checkbox" id="switch4" switch="none" value="1"
                                            name="show_in_footer"
                                            {{ old('show_in_footer', true) ? 'checked' : '' }} />
                                        <label for="switch4" data-on-label="{{ __('dashboard.yes') }}"
                                            data-off-label="{{ __('dashboard.no') }}"></label>
                                    </div>
                                </div>
                            </div>

                            <div class="col-12">
                                <hr>
                                <h4 class="card-title">{{ __('dashboard.seo') }}</h4>

                                <div class="row">
                                    <div class="form-group col-md-6">
                                        <label>{{ __('dashboard.meta_title_en') }}</label>
                                        <textarea class="form-control" name="meta_title_en" rows="2"
                                            placeholder="{{ __('dashboard.meta_title_en') }}">{{ old('meta_title_en') }}</textarea>
                                    </div>

                                    <div class="form-group col-md-6">
                                        <label for="meta_desc_en">{{ __('dashboard.meta_desc_en') }}</label>
                                        <textarea class="form-control" name="meta_desc_en" rows="2" placeholder="{{ __('dashboard.meta_desc_en') }}">{{ old('meta_desc_en') }}</textarea>
                                    </div>

                                    <div class="form-group col-md-6">
                                        <label>{{ __('dashboard.meta_title_ar') }}</label>
                                        <textarea class="form-control" name="meta_title_ar" rows="2"
                                            placeholder="{{ __('dashboard.meta_title_ar') }}">{{ old('meta_title_ar') }}</textarea>
                                    </div>

                                    <div class="form-group col-md-6">
                                        <label>{{ __('dashboard.meta_desc_ar') }}</label>
                                        <textarea class="form-control" name="meta_desc_ar" rows="2" placeholder="{{ __('dashboard.meta_desc_ar') }}">{{ old('meta_desc_ar') }}</textarea>
                                    </div>

                                    <div class="form-group col-md-12">
                                        <div class="d-flex flex-wrap gap-2">
                                            <h5 class="font-size-14 mb-3">{{ __('dashboard.meta_robots') }} (index)
                                            </h5>
                                            <input type="checkbox" id="switch5" switch="none" value="1"
                                                name="index" {{ old('index', true) ? 'checked' : '' }} />
                                            <label for="switch5" data-on-label="{{ __('dashboard.yes') }}"
                                                data-off-label="{{ __('dashboard.no') }}"></label>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="form-group col-md-12">
                                <button type="submit" class="btn btn-success">
                                    <i class="icon-note"></i> {{ __('dashboard.save') }}
                                </button>
                                <a href="{{ route('dashboard.services.index') }}" class="btn btn-danger ms-2">
                                    <i class="icon-trash"></i> {{ __('dashboard.cancel') }}
                                </a>
                            </div>

                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
    <!-- End Row -->

    @section('script')
        <!-- Setup global variables -->
        <script type="text/javascript">
            // Setup global variables for JavaScript files
            window.routes = {
                generateAI: "{{ route('dashboard.ai-content.generate') }}"
            };
            window.csrfToken = "{{ csrf_token() }}";
        </script>

        <!-- TinyMCE Editor Component -->
        <x-dashboard.tinymce-config />

        <!-- Service AI Content JavaScript - Inline Version -->
        <script>
            // Include same inline script as in edit.blade.php
            $(document).ready(function() {
                console.log('🔧 Loading inline AI content script for services (create)...');

                // Copy the same AI content generation code from edit.blade.php
                $('#generateServiceContent').on('click', function(e) {
                    e.preventDefault();
                    var contentType = $('#aiContentType').val();
                    var prompt = $('#aiPrompt').val().trim();
                    var language = $('#aiLanguage').val();
                    var length = $('#aiLength').val();

                    console.log('🚀 === AI SERVICE CONTENT GENERATION STARTED ===');
                    console.log('🌍 Selected language:', language);

                    if (!prompt) {
                        var nameEn = $('input[name="name_en"]').val();
                        var nameAr = $('input[name="name_ar"]').val();
                        if (nameAr) {
                            prompt = nameAr;
                            $('#aiPrompt').val(prompt);
                        } else if (nameEn) {
                            prompt = nameEn;
                            $('#aiPrompt').val(prompt);
                        }
                    }

                    if (!contentType) {
                        alert('يرجى اختيار نوع المحتوى');
                        return;
                    }
                    if (!prompt) {
                        alert('يرجى إدخال وصف الخدمة أو اسم الخدمة أولاً');
                        return;
                    }

                    var $btn = $(this);
                    var originalText = $btn.html();
                    $btn.prop('disabled', true).html(
                        '<i class="fas fa-spinner fa-spin me-2"></i>جاري التوليد...');
                    $('.card').addClass('ai-loading');

                    var fullPrompt = createServiceAIPrompt(contentType, prompt, language, length);

                    $.ajax({
                        url: window.routes?.generateAI || '/dashboard/ai-content/generate',
                        method: 'POST',
                        headers: {
                            'Content-Type': 'application/json',
                            'Accept': 'application/json',
                            'X-CSRF-TOKEN': window.csrfToken || $('meta[name="csrf-token"]').attr(
                                'content')
                        },
                        data: JSON.stringify({
                            type: 'service_content',
                            prompt: fullPrompt,
                            content_type: contentType,
                            language: language,
                            length: length,
                            options: {
                                max_tokens: getTokensByLength(length),
                                temperature: 0.7
                            }
                        }),
                        success: function(response) {
                            if (response.success && response.content) {
                                var content = response.content.content || response.content;
                                console.log('🎯 === APPLYING CONTENT TO ' + language.toUpperCase() +
                                    ' FIELD ===');
                                applyToFields(formatContentForEditor(content), language,
                                    contentType);
                                showStatus('تم توليد المحتوى بنجاح!', 'success');
                            } else {
                                showStatus(response.error || 'فشل في توليد المحتوى', 'danger');
                            }
                        },
                        error: function(xhr) {
                            var errorMsg = 'حدث خطأ في توليد المحتوى';
                            if (xhr.status === 419) errorMsg =
                                'انتهت صلاحية الصفحة، يرجى إعادة تحميل الصفحة';
                            showStatus(errorMsg, 'danger');
                        },
                        complete: function() {
                            $btn.prop('disabled', false).html(originalText);
                            $('.card').removeClass('ai-loading');
                        }
                    });
                });

                function createServiceAIPrompt(contentType, prompt, language, length) {
                    var languageInstruction = language === 'ar' ? 'اكتب النص باللغة العربية فقط.' :
                        'Write the text in English only.';
                    var basePrompt = 'اكتب وصف شامل عن خدمة: ' + prompt + '.';
                    return basePrompt + ' ' + languageInstruction;
                }

                function getTokensByLength(length) {
                    return length === 'short' ? 300 : length === 'long' ? 1500 : 800; // زيادة الحدود
                }

                function formatContentForEditor(content) {
                    if (!content) return content;

                    console.log('📝 Formatting content for better display...');
                    content = content.trim();

                    // تحويل النقاط والقوائم إلى HTML منسق
                    content = content.replace(/^\s*[\-\*\+]\s+/gm, '<li>');
                    content = content.replace(/^\s*\d+\.\s+/gm, '<li>');

                    // تحويل الفقرات وإضافة تنسيق
                    content = content.replace(/\n\n+/g, '</p>\n<p>');
                    content = content.replace(/\n/g, '<br>\n');
                    content = content.replace(/^(.+):$/gm, '<strong>$1:</strong>');
                    content = content.replace(/\*\*([^*]+)\*\*/g, '<strong>$1</strong>');
                    content = content.replace(/\*([^*]+)\*/g, '<em>$1</em>');

                    if (!content.startsWith('<p>')) content = '<p>' + content;
                    if (!content.endsWith('</p>')) content = content + '</p>';

                    // تنظيف القوائم
                    if (content.includes('<li>')) {
                        content = content.replace(/(<li>[^<]*(?:<[^>]*>[^<]*)*)/g, '<ul>$1</ul>');
                        content = content.replace(/<\/ul>\s*<ul>/g, '');
                    }

                    content = content.replace(/<\/p>\s*<p>/g, '</p>\n\n<p>');
                    console.log('✅ Content formatted successfully');
                    return content;
                }

                function applyToFields(content, lang, contentType) {
                    const fieldName = 'long_desc_' + lang;
                    console.log('🎯 Applying content to field:', fieldName);

                    if (lang === 'ar') {
                        $('textarea[name="long_desc_en"]').val('');
                        console.log('🧹 Cleared English field');
                    } else if (lang === 'en') {
                        $('textarea[name="long_desc_ar"]').val('');
                        console.log('🧹 Cleared Arabic field');
                    }

                    const $textarea = $('textarea[name="' + fieldName + '"]');
                    if ($textarea.length > 0) {
                        $textarea.val(content);
                        $textarea.trigger('change');
                        console.log('✅ Content applied to textarea ' + fieldName);

                        if (typeof tinymce !== 'undefined') {
                            const textareaId = $textarea.attr('id');
                            if (textareaId) {
                                const editor = tinymce.get(textareaId);
                                if (editor) {
                                    editor.setContent(content);
                                    console.log('🎨 ✅ Updated TinyMCE editor for ' + fieldName);
                                }
                            }
                        }
                    } else {
                        console.error('❌ Textarea ' + fieldName + ' not found!');
                    }
                }

                function showStatus(message, type) {
                    var alertClass = type === 'success' ? 'alert-success' : 'alert-danger';
                    $('#aiGenerationStatus').html(
                        '<div class="alert ' + alertClass + ' alert-dismissible fade show" role="alert">' +
                        message + '<button type="button" class="btn-close" data-bs-dismiss="alert"></button></div>'
                    );
                    if (type === 'success') {
                        setTimeout(function() {
                            $('#aiGenerationStatus').fadeOut();
                        }, 5000);
                    }
                }

                console.log('✅ Service AI Content script loaded inline successfully (create)');
            });
        </script>

        <!-- Additional scripts -->
        <script type="text/javascript">
            $(document).ready(function() {
                // File size validation
                $('input[type="file"]').on('change', function(e) {
                    var maxSize = 1 * 1024 * 1024; // 1MB
                    var files = this.files;

                    for (let i = 0; i < files.length; i++) {
                        if (files[i].size > maxSize) {
                            alert('أقصى حجم للصورة هو 1 ميجا');
                            this.value = ""; // Clear the field
                            break;
                        }
                    }
                });
            });
        </script>
    @endsection

</x-dashboard.layout>
