<x-dashboard.layout :title="__('dashboard.edit') . $product->name">

    <!-- Page Header -->
    <x-dashboard.partials.page-header :header="__('dashboard.edit') . $product->name" :label_url="route('dashboard.products.index')" :label="__('dashboard.products')" />
    <!-- End Page Header -->


    <!-- Row-->
    <div class="row">
        <div class="col-sm-12 col-xl-12 col-lg-12">
            <div class="card ">
                <div class="card-header d-flex justify-content-between">
                    <h4 class="card-title pt-3">{{ __('dashboard.edit') . $product->name }}</h4>
                </div>

                <div class="card-body">

                    <form action="{{ route('dashboard.products.update', [$product->id]) }}" method="POST"
                        enctype="multipart/form-data">
                        @csrf
                        @method('PATCH')
                        <div class="row">

                            <div class="form-group col-md-4">
                                <label class="">{{ __('dashboard.name_en') }}</label>
                                <input class="form-control" name="name_en" type="text"
                                    value="{{ $product->name_en }}" placeholder="{{ __('dashboard.name_en') }}">
                            </div>

                            <div class="form-group col-md-4">
                                <label class="">{{ __('dashboard.name_ar') }}</label>
                                <input class="form-control" name="name_ar" type="text"
                                    value="{{ $product->name_ar }}" placeholder="{{ __('dashboard.name_ar') }}">
                            </div>


                            <div class="form-group col-md-2">
                                <label class="">{{ __('dashboard.order') }}</label>
                                <input class="form-control" name="order" type="number" value="{{ $product->order }}"
                                    placeholder="{{ __('dashboard.order') }}">
                            </div>

                            <div class="form-group col-md-2">
                                <label for="parent">{{ __('dashboard.parent') }}</label>
                                <select class="form-control select2" name="parent_id">
                                    <option value="{{ $product->parent_id ?? null }}">
                                        {{ $product->parent?->name ?? __('dashboard.select_parent') }}
                                    </option>

                                    @foreach ($products as $productItem)
                                        <option @selected(old('parent_id') == $productItem->id) value="{{ $productItem->id }}">
                                            {{ $productItem->name }}
                                        </option>
                                    @endforeach
                                </select>
                            </div>

                            <div class=" form-group  col-md-6">
                                <label>{{ __('dashboard.image') }} (225px * 225px max 1mb)</label>
                                <input type="file" class="form-control" name="image">
                            </div>

                            <div class=" form-group  col-md-2">
                                <label for="">{{ __('dashboard.image') }}</label>
                                <img src="{{ $product->image_path }}" width="250">
                            </div>

                            <div class="form-group col-md-4">
                                <label class="">{{ __('dashboard.alt_image') }}</label>
                                <input class="form-control" name="alt_image" type="text"
                                    placeholder="{{ __('dashboard.alt_image') }}" value="{{ $product->alt_image }}">
                            </div>

                            <div class="form-group col-md-6">
                                <label>{{ __('dashboard.icon') }} (50px * 50px max 1mb)</label>
                                <input type="file" class="form-control" name="icon">

                            </div>

                            <div class=" form-group  col-md-2">
                                <label for="">{{ __('dashboard.icon') }}</label>
                                <img src="{{ $product->icon_path }}" width="250">
                            </div>

                            <div class="form-group col-md-4">
                                <label class="">{{ __('dashboard.alt_icon') }}</label>
                                <input class="form-control" name="alt_icon" type="text"
                                    placeholder="{{ __('dashboard.alt_icon') }}" value="{{ $product->alt_icon }}">
                            </div>


                            <div class="form-group col-md-6">
                                <label class="">{{ __('dashboard.short_desc_en') }}</label>
                                <textarea class="form-control" name="short_desc_en" type="text" placeholder="{{ __('dashboard.short_desc_en') }}">{!! $product->short_desc_en !!}</textarea>
                            </div>

                            <div class="form-group col-md-6">
                                <label class="">{{ __('dashboard.short_desc_ar') }}</label>
                                <textarea class="form-control" name="short_desc_ar" type="text" placeholder="{{ __('dashboard.short_desc_ar') }}">{!! $product->short_desc_ar !!}</textarea>
                            </div>
                            <div class="form-group col-md-6">
                                <label class="">{{ __('dashboard.long_desc_en') }}</label>
                                <textarea class="form-control" id="myeditorinstance" name="long_desc_en" type="text"
                                    placeholder="{{ __('dashboard.long_desc_en') }}">{!! $product->long_desc_en !!}</textarea>
                            </div>

                            <div class="form-group col-md-6">
                                <label class="">{{ __('dashboard.long_desc_ar') }}</label>
                                <textarea class="form-control" id="myeditorinstance" name="long_desc_ar" type="text"
                                    placeholder="{{ __('dashboard.long_desc_ar') }}">{!! $product->long_desc_ar !!}</textarea>
                            </div>
                            <br>
                            <hr>
                            <div class="form-group col-md-3">
                                <label class="">{{ __('dashboard.clients_en') }}</label>
                                <input class="form-control" name="clients_en" type="text"
                                    value="{{ $product->clients_en }}" placeholder="{{ __('dashboard.clients_en') }}">
                            </div>

                            <div class="form-group col-md-3">
                                <label class="">{{ __('dashboard.location_en') }}</label>
                                <input class="form-control" name="location_en" type="text"
                                    value="{{ $product->location_en }}"
                                    placeholder="{{ __('dashboard.location_en') }}">
                            </div>

                            <div class="form-group col-md-3">
                                <label class="">{{ __('dashboard.category_en') }}</label>
                                <input class="form-control" name="category_en" type="text"
                                    value="{{ $product->category_en }}"
                                    placeholder="{{ __('dashboard.category_en') }}">
                            </div>

                            <div class="form-group col-md-3">
                                <label class="">{{ __('dashboard.service_en') }}</label>
                                <input class="form-control" name="service_en" type="text"
                                    value="{{ $product->service_en }}"
                                    placeholder="{{ __('dashboard.service_en') }}">
                            </div>

                            <div class="form-group col-md-3">
                                <label class="">{{ __('dashboard.clients_ar') }}</label>
                                <input class="form-control" name="clients_ar" type="text"
                                    value="{{ $product->clients_ar }}"
                                    placeholder="{{ __('dashboard.clients_ar') }}">
                            </div>

                            <div class="form-group col-md-3">
                                <label class="">{{ __('dashboard.location_ar') }}</label>
                                <input class="form-control" name="location_ar" type="text"
                                    value="{{ $product->location_ar }}"
                                    placeholder="{{ __('dashboard.location_ar') }}">
                            </div>

                            <div class="form-group col-md-3">
                                <label class="">{{ __('dashboard.category_ar') }}</label>
                                <input class="form-control" name="category_ar" type="text"
                                    value="{{ $product->category_ar }}"
                                    placeholder="{{ __('dashboard.category_ar') }}">
                            </div>

                            <div class="form-group col-md-3">
                                <label class="">{{ __('dashboard.service_ar') }}</label>
                                <input class="form-control" name="service_ar" type="text"
                                    value="{{ $product->service_ar }}"
                                    placeholder="{{ __('dashboard.service_ar') }}">
                            </div>
                            <div class="form-group col-md-4">
                                <label class="">{{ __('dashboard.date') }}</label>
                                <input class="form-control" name="date" type="date"
                                    value="{{ $product->date }}" placeholder="{{ __('dashboard.date') }}">
                            </div>
                            <br>
                            <hr>
                            <div class="row align-items-center mb-3">
                                <div class="col-md-10">
                                    <h6 class="card-title mb-1">
                                        {{ trans('home.edit_category') }}
                                        <span class="badge badge-warning">
                                            {{ trans('home.changing category will change specifications values') }}
                                        </span>
                                    </h6>
                                </div>
                                <div class="col-md-2 text-end">
                                    <a type="button" class="btn btn-outline-secondary" data-bs-toggle="modal"
                                        data-bs-target="#Modal1">
                                        <i class="fas fa-edit" style="color:black"></i>
                                    </a>
                                </div>
                                <div class="col-md-12 mt-2">
                                    <div class="form-group">
                                        <select class="form-control select2" name="category_id" id="category_id">
                                            <option value="{{ $product->category_id }}">
                                                {{ $product->category?->{'name_' . app()->getLocale()} ?? '' }}
                                            </option>
                                        </select>
                                    </div>
                                </div>
                            </div>
                            <div class="form-group col-md-12">
                                <hr>
                                <label for="product_images">{{ __('dashboard.product_images') }}</label>
                                <input type="file" class="form-control" name="product_images[]" multiple
                                    accept="image/*">
                            </div>
                            <br>
                            <hr>
                            <br>
                            @if (!empty($product->images) && $product->images->count() > 0)
                                <div id="delete_selected_images_form">
                                    <div class="d-flex flex-wrap mb-2 align-items-center">
                                        <button type="button" id="select_all_btn" class="btn btn-secondary mr-2"
                                            style="margin: 5px;">{{ __('dashboard.select_all') }}</button>
                                        <button type="button" id="delete_selected_btn" class="btn btn-danger mr-2"
                                            style="margin: 5px;">{{ __('dashboard.delete_selected') }}</button>
                                        <a href='#' data-id="{{ $product->id }}"
                                            class='delete_all_img btn btn-danger'
                                            style="margin: 5px;">{{ __('dashboard.delete_all') }}</a>
                                        <button type="button" id="save_order_btn" class="btn btn-success mr-2"
                                            style="margin: 5px;">{{ __('dashboard.save_order') }}</button>
                                    </div>
                                    <div class="col-md-12 mt-3">
                                        <div class="row mb-0" id="sortable-images">
                                            @foreach ($product->images as $key => $image)
                                    <div class="col-md-3 col-sm-6 mb-3 sortable-container" data-id="{{ $image->id }}">
                                        <div class="card">
                                            <div class="position-relative">
                                                <div class="drag-handle">⋮⋮</div>
                                                <img class="card-img-top" src="{{ $image->image_url }}"
                                                    style="height: 200px; object-fit: cover;">
                                            </div>
                                            <div class="card-body text-center">
                                                <input type="checkbox" name="selected_images[]"
                                                    value="{{ $image->id }}" class="select_image_checkbox mb-2">
                                                <button type="button" data-image="{{ $image->id }}"
                                                    class="delete_img_btn btn btn-danger btn-sm">
                                                    {{ trans('dashboard.delete') }}
                                                </button>
                                            </div>
                                        </div>
                                    </div>
                                    @endforeach
                                        </div>
                                    </div>
                                </div>
                            @endif
                            <div class="row mt-3">
                                <div class="form-group col-md-3">
                                    <div class="d-flex flex-wrap gap-2">
                                        <h5 class="font-size-14 mb-3">{{ __('dashboard.publish/unpublish') }} </h5>
                                        <input type="checkbox" id="switch1" switch="none" value="1"
                                            name="status" @checked(old('status', $product->status)) />
                                        <label for="switch1" data-on-label="{{ __('dashboard.yes') }}"
                                            data-off-label="{{ __('dashboard.no') }}"></label>
                                    </div>
                                </div>
                                <div class="form-group col-md-3">
                                    <div class="d-flex flex-wrap gap-2">
                                        <h5 class="font-size-14 mb-3">{{ __('dashboard.show_in_home') }}</h5>
                                        <input type="checkbox" id="switch2" switch="none" value="1"
                                            name="show_in_home" @checked(old('show_in_home', $product->show_in_home)) />
                                        <label for="switch2" data-on-label="{{ __('dashboard.yes') }}"
                                            data-off-label="{{ __('dashboard.no') }}"></label>
                                    </div>
                                </div>
                                <div class="form-group col-md-3">
                                    <div class="d-flex flex-wrap gap-2">
                                        <h5 class="font-size-14 mb-3">{{ __('dashboard.show_in_header') }} </h5>
                                        <input type="checkbox" id="switch3" switch="none" value="1"
                                            name="show_in_header" @checked(old('show_in_header', $product->show_in_header)) />
                                        <label for="switch3" data-on-label="{{ __('dashboard.yes') }}"
                                            data-off-label="{{ __('dashboard.no') }}"></label>
                                    </div>
                                </div>
                                <div class="form-group col-md-3">
                                    <div class="d-flex flex-wrap gap-2">
                                        <h5 class="font-size-14 mb-3">{{ __('dashboard.show_in_footer') }} </h5>
                                        <input type="checkbox" id="switch4" switch="none" value="1"
                                            name="show_in_footer" @checked(old('show_in_footer', $product->show_in_footer)) />
                                        <label for="switch4" data-on-label="{{ __('dashboard.yes') }}"
                                            data-off-label="{{ __('dashboard.no') }}"></label>
                                    </div>
                                </div>

                            </div>


                            <div class="col-12">
                                <div class="row">
                                    <div class="form-group col-md-12">
                                        <hr>
                                        <h4 class="card-title">{{ __('dashboard.seo') }}</h4>
                                    </div>
                                    <div class="form-group col-md-2">
                                        <label for="name_ar">{{ __('dashboard.slug_en') }}</label>
                                        <input type="text" autocomplete="off" class="form-control"
                                            placeholder="{{ __('dashboard.slug_en') }}" name="slug_en"
                                            value="{{ $product->slug_en }}">
                                    </div>

                                    <div class="form-group col-md-5">
                                        <label> {{ __('dashboard.meta_title_en') }}</label>
                                        <textarea class="form-control" name="meta_title_en" placeholder="{{ __('dashboard.meta_title_en') }}"> {!! $product->meta_title_en !!}</textarea>
                                    </div>

                                    <div class="form-group col-md-5">
                                        <label for="meta_desc"> {{ __('dashboard.meta_desc_en') }}</label>
                                        <textarea class="form-control" name="meta_desc_en" placeholder="{{ __('dashboard.meta_desc_en') }}"> {!! $product->meta_desc_en !!}</textarea>
                                    </div>

                                    <div class="form-group col-md-12">
                                        <hr>

                                    </div>

                                    <div class="form-group col-md-2">
                                        <label>{{ __('dashboard.slug_ar') }}</label>
                                        <input type="text" autocomplete="off" class="form-control"
                                            placeholder="{{ __('dashboard.slug_ar') }}" name="slug_ar"
                                            value="{{ $product->slug_ar }}">
                                    </div>

                                    <div class="form-group col-md-5">
                                        <label> {{ __('dashboard.meta_title_ar') }}</label>
                                        <textarea class="form-control" name="meta_title_ar" placeholder="{!! __('dashboard.meta_title_ar') !!}">{{ $product->meta_title_ar }}</textarea>
                                    </div>

                                    <div class="form-group col-md-5">
                                        <label> {{ __('dashboard.meta_desc_ar') }}</label>
                                        <textarea class="form-control" name="meta_desc_ar" placeholder="{!! __('dashboard.meta_desc') !!}">{!! $product->meta_desc_ar !!}</textarea>
                                    </div>


                                    <div class="d-flex flex-wrap gap-2">
                                        <h5 class="font-size-14 mb-3">{{ __('dashboard.meta_robots') }} (index)</h5>
                                        <input type="checkbox" id="switch5" switch="none" value="1"
                                            name="index" @checked(old('index', $product->index)) />
                                        <label for="switch5" data-on-label="{{ __('dashboard.yes') }}"
                                            data-off-label="{{ __('dashboard.no') }}"></label>

                                    </div>
                                </div>
                            </div>
                            <div class="form-group col-md-12">
                                <button type="submit" class="btn btn-success"><i class="icon-note"></i>
                                    {{ __('dashboard.update') }} </button>
                                <a href="{{ route('dashboard.products.index') }}"><button type="button"
                                        class="btn btn-danger mr-1"><i class="icon-trash"></i>
                                        {{ __('dashboard.cancel') }}</button></a>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
    <!-- End Row -->

    <!-- modal1 -->
    <div class="modal fade text-left" id="Modal1" tabindex="-1" role="dialog" aria-labelledby="myModalLabel34"
        aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header justify-content-between">
                    <h3 class="modal-title" id="myModalLabel34">{{ trans('home.edit_category') }}</h3>
                    <a type="button" class="close" data-bs-dismiss="modal" aria-bs-label="Close">
                        X
                    </a>
                </div>
                <form action="{{ route('dashboard.dashboard.products.changeCategory', $product->id) }}"
                    method="post">
                    @csrf
                    <div class="modal-body">
                        <div class="row">

                            <div class="form-group col-md-12">
                                <select class="form-control" data-trigger name="category_id" id="category" required>
                                    <option></option>
                                    @foreach ($categories as $category)
                                        <option value="{{ $category->id }}"
                                            {{ $product->category_id == $category->id ? 'selected' : '' }}>
                                            {{ app()->getLocale() == 'en' ? $category->name_en : $category->name_ar }}
                                        </option>
                                    @endforeach
                                </select>
                            </div>

                            <div class="form-group col-md-12 mt-3">
                                <button type="submit" class="btn btn-primary w-md"> {{ trans('home.save') }}
                                </button>
                            </div>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
    @section('script')
        <script src="https://cdn.jsdelivr.net/npm/sortablejs@1.15.0/Sortable.min.js"></script>
        <script>
            // زر تحديد الكل/إلغاء التحديد
            var allSelected = false;
            $('#select_all_btn').on('click', function() {
                allSelected = !allSelected;
                $('input.select_image_checkbox').prop('checked', allSelected);
                $(this).text(allSelected ? '{{ __('dashboard.unselect_all') }}' :
                    '{{ __('dashboard.select_all') }}');
            });
        </script>
        <script>
            // حذف الصور المختارة
            $('#delete_selected_btn').on('click', function(e) {
                e.preventDefault();
                var selected = [];
                $('input.select_image_checkbox:checked').each(function() {
                    selected.push($(this).val());
                });
                if (selected.length === 0) {
                    alert('يرجى اختيار الصور المراد حذفها');
                    return;
                }
                if (confirm('هل أنت متأكد من حذف الصور المحددة؟')) {
                    $.ajax({
                        url: "{{ route('dashboard.dashboard.products.deleteSelectedImages') }}",
                        method: 'POST',
                        data: {
                            image_ids: selected,
                            _token: token
                        },
                        success: function(data) {
                            if (data.success) {
                                location.reload();
                            } else {
                                alert(data.message || 'حدث خطأ أثناء الحذف');
                            }
                        },
                        error: function(xhr) {
                            alert(xhr.responseJSON?.message || 'حدث خطأ أثناء الحذف');
                        }
                    });
                }
            });
        </script>
        <script>
            $('.delete_all_img').on('click', function(e) {
                e.preventDefault();
                var productId = $(this).data('id');
                if (confirm('{{ __('dashboard.confirm_delete_all_images') }}')) {
                    $.ajax({
                        url: "{{ route('dashboard.dashboard.products.deleteAllImages') }}",
                        method: 'POST',
                        data: {
                            product_id: productId,
                            _token: token
                        },
                        success: function(data) {
                            if (data.success) {
                                location.reload();
                            } else {
                                alert(data.message || 'حدث خطأ أثناء الحذف');
                            }
                        },
                        error: function(xhr) {
                            alert(xhr.responseJSON?.message || 'حدث خطأ أثناء الحذف');
                        }
                    });
                }
            });
        </script>
        <script src="https://cdnjs.cloudflare.com/ajax/libs/dropzone/4.0.1/dropzone.js"></script>

        <script type="text/javascript">
            var token = "{{ csrf_token() }}";
            Dropzone.autoDiscover = false;

            $("div.upload_images").dropzone({
                addRemoveLinks: true,
                acceptedFiles: ".jpeg,.jpg,.png,.gif,.svg.webp",
                maxFilesize: 3, // MB
                url: "{{ route('dashboard.dashboard.products.uploadImages') }}",

                init: function() {
                    this.on("sending", function(file, xhr, formData) {
                        formData.append("productId", "{{ $product->id }}");
                    });
                },

                params: {
                    _token: token,
                    type: 'product_image',
                },

                removedfile: function(file) {
                    var fileName = file.name;
                    $.ajaxSetup({
                        headers: {
                            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                        }
                    });
                    $.ajax({
                        type: 'POST',
                        url: "{{ route('dashboard.dashboard.products.removeUploadImages') }}", // استخدم route بدلاً من URL::to
                        data: {
                            type: 'product_image',
                            name: fileName,
                            request: 'delete'
                        },
                        success: function(data) {
                            console.log('success: ' + data);
                        }
                    });
                    var _ref;
                    return (_ref = file.previewElement) != null ? _ref.parentNode.removeChild(file.previewElement) :
                        void 0;
                }
            });

            Dropzone.options.myDropzone = {
                maxFilesize: 1, // MB
                dictFileTooBig: "أقصى حجم للصورة هو 1 ميجا.",
                accept: function(file, done) {
                    if (file.size > 1 * 1024 * 1024) {
                        done("أقصى حجم للصورة هو 1 ميجا.");
                    } else {
                        done();
                    }
                }
            };

            $('.delete_img_btn').on('click', function() {
                var image = $(this).data('image');
                var productId = "{{ $product->id }}";
                var btn = $(this);
                $.ajaxSetup({
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    }
                });
                $.ajax({
                    url: "{{ route('dashboard.dashboard.products.deleteImage') }}",
                    method: 'POST',
                    data: {
                        image: image,
                        productId: productId
                    },
                    success: function(data) {
                        location.href = "{{ route('dashboard.products.edit', $product->id) }}";
                    }
                });
            });

            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });

            // تفعيل drag & drop للصور
            var sortableImages = document.getElementById('sortable-images');
            if (sortableImages) {
                new Sortable(sortableImages, {
                    animation: 150,
                    ghostClass: 'sortable-ghost',
                    chosenClass: 'sortable-chosen',
                    handle: '.drag-handle',
                    onEnd: function(evt) {
                        console.log('تم تغيير الترتيب');
                    }
                });
            }

            // حفظ الترتيب الجديد
            $('#save_order_btn').on('click', function() {
                var imageIds = [];
                $('#sortable-images .sortable-container').each(function() {
                    imageIds.push($(this).data('id'));
                });

                if (imageIds.length === 0) {
                    alert('لا توجد صور لحفظ ترتيبها');
                    return;
                }

                $.ajax({
                    url: "{{ route('dashboard.dashboard.products.reorderImages') }}",
                    method: 'POST',
                    data: {
                        image_ids: imageIds,
                        _token: token
                    },
                    success: function(data) {
                        if (data.success) {
                            alert(data.message || 'تم حفظ الترتيب بنجاح');
                        } else {
                            alert(data.message || 'حدث خطأ أثناء حفظ الترتيب');
                        }
                    },
                    error: function(xhr) {
                        alert(xhr.responseJSON?.message || 'حدث خطأ أثناء حفظ الترتيب');
                    }
                });
            });
        </script>
        <script>
            $('input[type="file"][name="product_images[]"]').on('change', function(e) {
                var maxSize = 1 * 1024 * 1024; // 1MB
                for (let i = 0; i < this.files.length; i++) {
                    if (this.files[i].size > maxSize) {
                        alert('أقصى حجم للصورة هو 1 ميجا');
                        this.value = ""; // إفراغ الحقل
                        break;
                    }
                }
            });
        </script>
        @if ($errors->has('product_images.*'))
            <div class="alert alert-danger">
                {{ $errors->first('product_images.*') }}
            </div>
        @endif
    @endsection

</x-dashboard.layout>
