<?php

namespace Database\Seeders;

use App\Models\Project;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class ProjectSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $data = [
            [
                'name_ar' => 'مشروع 1',
                'name_en' => 'Project 1',
                'short_desc_ar' => 'مشروع 1 سريع وآمن',
                'short_desc_en' => 'Fast and secure project 1',
                'long_desc_ar' => 'مشروع 1 موثوق وسريع مع دعم فني على مدار الساعة',
                'long_desc_en' => 'Reliable and fast project 1 with 24/7 support',
                'status' => 1,
                'show_in_home'=> 1,
                'show_in_header'=> 1,
                'slug_ar' => 'مشروع-1',
                'slug_en' => 'project-1',
                'meta_title_ar' => 'مشروع 1',
                'meta_title_en' => 'Project 1',
                'meta_desc_ar' => 'مشروع 1 موثوق وسريع مع دعم فني على مدار الساعة',
                'meta_desc_en' => 'Reliable and fast project 1 with 24/7 support',
                'index' => 1,
                'category_id' => 4,
                'alt_image' => 'مشروع 1',
                'alt_icon' => 'مشروع 1',
                'order' => 1,
                'clients_en' => 'مشروع 1',
                'location_en' => 'مشروع 1',
                'date' => '2025-01-01',
                'category_en' => 'مشروع 1',
                'service_en' => 'مشروع 1',
                'clients_ar' => 'مشروع 1',
                'location_ar' => 'مشروع 1',
                'category_ar' => 'مشروع 1',
                'service_ar' => 'مشروع 1',
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'name_ar' => 'مشروع 2',
                'name_en' => 'Project 2',
                'short_desc_ar' => 'مشروع 2 سريع وآمن',
                'short_desc_en' => 'Fast and secure project 2',
                'long_desc_ar' => 'مشروع 2 موثوق وسريع مع دعم فني على مدار الساعة',
                'long_desc_en' => 'Reliable and fast project 2 with 24/7 support',
                'status' => 1,
                'show_in_home'=> 1,
                'show_in_header'=> 1,
                'slug_ar' => 'مشروع-2',
                'slug_en' => 'project-2',
                'meta_title_ar' => 'مشروع 2',
                'meta_title_en' => 'Project 2',
                'meta_desc_ar' => 'مشروع 2 موثوق وسريع مع دعم فني على مدار الساعة',
                'meta_desc_en' => 'Reliable and fast project 2 with 24/7 support',
                'index' => 1,
                'category_id' => 5,
                'alt_image' => 'مشروع 2',
                'alt_icon' => 'مشروع 2',
                'order' => 2,
                'clients_en' => 'مشروع 2',
                'location_en' => 'مشروع 2',
                'date' => '2025-01-02',
                'category_en' => 'مشروع 2',
                'service_en' => 'مشروع 2',
                'clients_ar' => 'مشروع 2',
                'location_ar' => 'مشروع 2',
                'category_ar' => 'مشروع 2',
                'service_ar' => 'مشروع 2',
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'name_ar' => 'مشروع 3',
                'name_en' => 'Project 3',
                'short_desc_ar' => 'مشروع 3 سريع وآمن',
                'short_desc_en' => 'Fast and secure project 3',
                'long_desc_ar' => 'مشروع 3 موثوق وسريع مع دعم فني على مدار الساعة',
                'long_desc_en' => 'Reliable and fast project 3 with 24/7 support',
                'status' => 1,
                'show_in_home'=> 1,
                'show_in_header'=> 1,
                'slug_ar' => 'مشروع-3',
                'slug_en' => 'project-3',
                'meta_title_ar' => 'مشروع 3',
                'meta_title_en' => 'Project 3',
                'meta_desc_ar' => 'مشروع 3 موثوق وسريع مع دعم فني على مدار الساعة',
                'meta_desc_en' => 'Reliable and fast project 3 with 24/7 support',
                'index' => 1,
                'category_id' => 6,
                'alt_image' => 'مشروع 3',
                'alt_icon' => 'مشروع 3',
                'order' => 3,
                'clients_en' => 'مشروع 3',
                'location_en' => 'مشروع 3',
                'date' => '2025-01-03',
                'category_en' => 'مشروع 3',
                'service_en' => 'مشروع 3',
                'clients_ar' => 'مشروع 3',
                'location_ar' => 'مشروع 3',
                'category_ar' => 'مشروع 3',
                'service_ar' => 'مشروع 3',
                'created_at' => now(),
                'updated_at' => now(),
            ]
        ];
        foreach ($data as $item) {
            Project::create($item);
        }
    }
}
